package live.attach.infrastructure.octopus.rest.dto;

import java.util.List;

public class SessionResponse {
    public String cookie;
    public final Meta meta;

    public SessionResponse(Meta meta) {
        this.meta = meta;
    }

    public static class Meta {
        public final Server server;
        public final Session session;
        public final Participant participant;
        public final List<Warning> warnings;

        public Meta(Server server, Session session, Participant participant, List<Warning> warnings) {
            this.server = server;
            this.session = session;
            this.participant = participant;
            this.warnings = warnings;
        }

        public boolean sessionExist() {
            return this.session != null;
        }

        public static class Session {
            public final String token;
            public final Options options;

            public Session(String token, Options options) {
                this.token = token;
                this.options = options;
            }

            public static class Options {
                public boolean isDevelopment;
                public boolean isGenuine;
                public String providedUserId;

                public Options(boolean isDevelopment, boolean isGenuine, String providedUserId) {
                    this.isDevelopment = isDevelopment;
                    this.isGenuine = isGenuine;
                    this.providedUserId = providedUserId;
                }
            }
        }

        public static class Warning {
            public final String code;
            public final String message;

            public Warning(String code, String message) {
                this.code = code;
                this.message = message;
            }
        }

        public static class Server {
            public final String hostname;

            public Server(String hostname) {
                this.hostname = hostname;
            }
        }

        public static class Participant {
            public final String socketId;
            public final User user;

            public Participant(String socketId, User user) {
                this.socketId = socketId;
                this.user = user;
            }

            public static class User {
                public final String id;
                public final String avatar;
                public final String username;

                public User(String id, String avatar, String username) {
                    this.id = id;
                    this.avatar = avatar;
                    this.username = username;
                }
            }
        }
    }
}
