package live.attach.infrastructure.octopus.rest.dto;

import java.util.List;

public class RoomSessionResponse {
    public final RoomSessionResponse.Meta meta;
    public final RoomSessionResponse.Data data;

    public RoomSessionResponse(Meta meta, Data data) {
        this.meta = meta;
        this.data = data;
    }

    public static class Data {
        public final String provider;
        public final String type;
        public final String identifier;

        public Data(String provider, String type, String identifier) {
            this.provider = provider;
            this.type = type;
            this.identifier = identifier;
        }
    }

    public static class Meta {
        public final RoomSessionResponse.Meta.Server server;
        public final RoomSessionResponse.Meta.Room room;
        public final List<Warning> warnings;


        public Meta(Server server, Room room, List<Warning> warnings) {
            this.server = server;
            this.room = room;
            this.warnings = warnings;
        }

        public boolean roomExist() {
            return this.room != null;
        }

        public static class Room {
            public final String token;

            public Room(String token) {
                this.token = token;
            }
        }

        public static class Warning {
            public final String code;
            public final String message;

            public Warning(String code, String message) {
                this.code = code;
                this.message = message;
            }
        }

        public static class Server {
            public final String hostname;

            public Server(String hostname) {
                this.hostname = hostname;
            }
        }
    }
}
