package live.attach.infrastructure.octopus.rest;

import live.attach.repackaged.com.google.gson.Gson;

import java.util.HashMap;
import java.util.Map;

import live.attach.repackaged.io.reactivex.Observable;
import live.attach.application.AttachEnvironment;
import live.attach.domain.model.exception.error.HttpSessionExpiredException;
import live.attach.infrastructure.http.HttpResponse;
import live.attach.infrastructure.http.JavaHttpService;
import live.attach.infrastructure.octopus.rest.dto.ErrorBody;
import live.attach.infrastructure.octopus.rest.dto.ResponseError;
import live.attach.infrastructure.octopus.rest.dto.RoomSessionResponse;
import live.attach.infrastructure.octopus.rest.dto.SessionResponse;
import okhttp3.ResponseBody;

public class OctopusHttpApi {
    private final JavaHttpService httpService;
    private final Gson gson;
    private final AttachEnvironment environment;

    public OctopusHttpApi(JavaHttpService httpService, AttachEnvironment environment) {
        this.httpService = httpService;
        this.environment = environment;
        this.gson = new Gson();
    }

    public Observable<SessionResponse> getSession(
        String url,
        String user,
        String cookie
    ) {
        return Observable.create(emitter -> {
            Map<String, String> params = new HashMap<>();
            params.put("user", user);

            Map<String, String> headers = environment.getOctopusHeaders();
            if (cookie != null) {
                headers.put("Cookie", cookie);
            }

            HttpResponse response = httpService.get(url, params, headers);
            SessionResponse sessionResponse = gson.fromJson(response.getBody(), SessionResponse.class);
            sessionResponse.cookie = response.getHeader("set-cookie");
            emitter.onNext(sessionResponse);
            emitter.onComplete();
        });
    }

    public Observable<RoomSessionResponse> getRoom(
        String url,
        String item,
        String sessionToken
    ) {
        return Observable.create(emitter -> {
            Map<String, String> params = new HashMap<>();
            params.put("item", item);
            params.put("session-token", sessionToken);

            Map<String, String> headers = environment.getOctopusHeaders();

            HttpResponse response = httpService.get(url, params, headers);
            RoomSessionResponse roomSessionResponse = gson.fromJson(response.getBody(), RoomSessionResponse.class);
            if (response.getStatus() == 401) {
                emitter.onError(new HttpSessionExpiredException());
                return;
            }
            emitter.onNext(roomSessionResponse);
            emitter.onComplete();
        });
    }
}
