package live.attach.infrastructure.logger;

import android.util.Log;

import live.attach.application.AttachEnvironment;
import live.attach.infrastructure.http.JavaHttpService;
import live.attach.repackaged.com.google.gson.Gson;

public class RemoteLogger implements AttachLogger {
    private static class LogEntry {
        private final String level;
        private final String app;
        private final String env;
        private final String line;
        private final String source;
        private final long timestamp;

        public LogEntry(String env, String line, String packageName) {
            this.level = "ERROR";
            this.app = "attach-android-sdk";
            this.env = env;
            this.line = line;
            this.source = packageName;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private final AttachEnvironment attachEnvironment;
    private final JavaHttpService httpService;
    private final Gson gson;

    public RemoteLogger(AttachEnvironment attachEnvironment, JavaHttpService httpService, Gson gson) {
        this.attachEnvironment = attachEnvironment;
        this.httpService = httpService;
        this.gson = gson;
    }

    private void sendLog(String message) {
        new Thread(() -> {
            try {
                LogEntry entry = new LogEntry(
                    attachEnvironment.isAttachDevelopment() ? "development" : "production",
                    message,
                    attachEnvironment.getPackageName()
                );
                httpService.post(
                    attachEnvironment.getLoggingUrl(),
                    gson.toJson(entry),
                    attachEnvironment.getLoggingHeaders()
                );
            } catch (Exception e) {
                //ignore
            }
        }).start();
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void remote(String message) {
    }

    @Override
    public void info(String message) {
    }

    @Override
    public void warning(String message, Throwable exception) {
    }

    @Override
    public void error(String message, Throwable exception) {
        if (exception == null) {
            sendLog(message);
        } else {
            sendLog(Log.getStackTraceString(exception));
        }
    }

    @Override
    public boolean reportsErrors() {
        return true;
    }
}
