package live.attach.infrastructure.logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CollectionLogger implements AttachLogger {
    private List<AttachLogger> loggers;
    private boolean errorReporting = false;

    CollectionLogger() {
        this.loggers = new ArrayList<>();
    }

    void addLogger(AttachLogger logger) {
        Iterator<AttachLogger> iterator = loggers.iterator();
        while (iterator.hasNext()) {
            AttachLogger next = iterator.next();
            if (next.getClass().equals(logger.getClass())) {
                iterator.remove();
            }
        }
        this.loggers.add(logger);
    }

    @Override
    public void debug(String message) {
        for (AttachLogger l : loggers) l.debug(message);
    }

    @Override
    public void remote(String message) {
        for (AttachLogger l : loggers) l.remote(message);
    }

    @Override
    public void info(String message) {
        for (AttachLogger l : loggers) l.info(message);
    }

    @Override
    public void warning(String message, Throwable exception) {
        for (AttachLogger l : loggers) l.warning(message, exception);
    }

    @Override
    public void error(String message, Throwable exception) {
        for (AttachLogger l : loggers) {
            if (l.reportsErrors()) {
                if (errorReporting) l.error(message, exception);
            } else {
                l.error(message, exception);
            }
        }
    }

    void setErrorReporting(boolean errorReporting) {
        this.errorReporting = errorReporting;
    }
}
