package live.attach.infrastructure.logger;

public class AttachLoggerFactory {
    private static CollectionLogger logger;

    private static CollectionLogger initLogger() {
        if (logger == null) {
            logger = new CollectionLogger();
        }
        return logger;
    }

    public static AttachLogger getLogger() {
        return initLogger();
    }

    public static void registerLogger(AttachLogger logger) {
        AttachLoggerFactory.initLogger().addLogger(logger);
    }

    public static void setErrorReporting(boolean enabled) {
        initLogger().setErrorReporting(enabled);
    }
}
