package live.attach.infrastructure.logger;

public interface AttachLogger {
    void debug(String message);

    void remote(String message);

    void info(String message);

    default void warning(String message) {
        warning(message, null);
    }

    void warning(String message, Throwable exception);

    default void error(String message) {
        error(message, null);
    }

    void error(String message, Throwable exception);

    default void error(Throwable exception) {
        error(exception.getMessage(), exception);
    }

    default boolean reportsErrors() {
        return false;
    }
}
