package live.attach.infrastructure.http;

import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private final String body;
    private final int status;
    private Map<String, String> headers;

    public HttpResponse(int status, String body, Map<String, String> headers) {
        this.body = body;
        this.status = status;
        this.headers = headers;
    }

    public HttpResponse(int status, String body) {
        this(status, body, new HashMap<>());
    }

    public String getBody() {
        return body;
    }

    public int getStatus() {
        return status;
    }

    public String getHeader(String header) {
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase(header)) {
                return headers.get(key);
            }
        }
        return null;
    }
}
