package live.attach.infrastructure.env;

import android.content.Context;

import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import live.attach.infrastructure.logger.AndroidDebugLogger;
import live.attach.infrastructure.logger.AttachLoggerFactory;
import live.attach.sdk.AttachSdk;
import live.attach.sdk.BuildConfig;

class DevelopmentEnvironment extends AttachAndroidEnvironment {
    private final String proxyKey;

    DevelopmentEnvironment(Context context, String clientApiKey) throws Exception {
        super(context, clientApiKey);
        proxyKey = BuildConfig.DEV_PROXY_AUTH_KEY;
    }

    @Override
    public Map<String, String> getPlatformHeaders() {
        Map<String, String> headers = super.getPlatformHeaders();
        headers.put("X-Attach-Proxy-Key", proxyKey);
        return headers;
    }

    @Override
    public Map<String, String> getOctopusHeaders() {
        Map<String, String> headers = super.getOctopusHeaders();
        headers.put("X-Attach-Proxy-Key", proxyKey);
        return headers;
    }

    @Override
    public boolean isAttachDevelopment() {
        return true;
    }

    @Override
    public String extractSessionCookie(String setCookie) {
        List<HttpCookie> cookies = HttpCookie.parse(setCookie);
        for (HttpCookie cookie : cookies) {
            if (cookie.getName().equals("dev-session")) return cookie.getValue();
        }
        return null;
    }

    public String createSessionCookie(String cookie) {
        return "dev-session=" + cookie;
    }
}
