package live.attach.infrastructure.android.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.util.Base64;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Properties;

public class AndroidUtils {
    public static final String getKeyHash(Context context) {
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), PackageManager.GET_SIGNATURES);
            for (Signature signature : info.signatures) {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString(md.digest(), Base64.DEFAULT).trim();
            }
            return "";
        } catch (Exception e) {
            return "";
        }
    }

    public static String getStringResourceByName(String stringName, Context context, int defaultRes) {
        try {
            String packageName = context.getPackageName();
            int resId = context.getResources().getIdentifier(stringName, "string", packageName);
            return context.getString(resId);
        } catch (Exception e) {
            return context.getString(defaultRes);
        }
    }

    public static Properties readAssetsProperties(Context context, String file) throws IOException {
        try {
            Properties properties = new Properties();
            AssetManager assetManager = context.getAssets();
            InputStream inputStream = assetManager.open(file);
            properties.load(inputStream);
            return properties;
        } catch (Exception ex) {
            throw new IOException("Cannot read application properties. Make sure you have the release version of library.");
        }
    }
}
