package live.attach.infrastructure.android.theme;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;

import live.attach.sdk.R;
import live.attach.domain.model.application.AttachProperties;

public class ThemeResolver {
    public static AttachProperties resolveTheme(Context context) {
        int androidPrimaryInt = getThemeAttr(context, R.attr.colorPrimary, color(context, R.color.attachColorPrimary));
        int androidAccentInt = getThemeAttr(context, R.attr.colorAccent, color(context, R.color.attachColorAccent));
        int androidBackgroundInt = getThemeAttr(context, R.attr.background, color(context, R.color.attachColorBackground));

        int attachPrimaryInt = getThemeAttr(context, R.attr.attachColorPrimary, androidPrimaryInt);
        int attachAccentInt = getThemeAttr(context, R.attr.attachColorAccent, androidAccentInt);
        int attachBackgroundInt = getThemeAttr(context, R.attr.attachColorBackground, androidBackgroundInt);

        return new AttachProperties(
            colorHex(attachPrimaryInt),
            colorHex(attachAccentInt),
            colorHex(attachBackgroundInt),
            "round"
        );

//        int participantsStyleId = getThemeAttr(context, R.attr.attach_participants, 0);
//        if (participantsStyleId != 0) {
//            applyParticipantsStyle(brandingProperties, context, participantsStyleId);
//
//        }
//
//        int chatStyleId = getThemeAttr(context, R.attr.attach_chat, 0);
//        if (chatStyleId != 0) {
//            applyChatStyle(brandingProperties, context, chatStyleId);
//
//        }
//
//        int videoCallStyle = getThemeAttr(context, R.attr.attach_videocall, 0);
//        if (chatStyleId != 0) {
//            applyVideoCallStyle(brandingProperties, context, videoCallStyle);
//
//        }
    }

//    private static void applyParticipantsStyle(BrandingProperties brandingProperties, Context context, int participantsStyleId) {
//        TypedArray ta = context.obtainStyledAttributes(participantsStyleId, R.styleable.AttachParticipants);
//
//        int focusBackgroundColor = ta.getColor(
//            R.styleable.AttachParticipants_attach_participants_focusBackgroundColor,
//            colorInt(brandingProperties.getParticipantsStyle().getFocusBackgroundColor().value)
//        );
//        brandingProperties.getParticipantsStyle().setFocusBackgroundColor(new Color(colorHex(focusBackgroundColor)));
//
//        int viewerBackgroundColor = ta.getColor(
//            R.styleable.AttachParticipants_attach_participants_viewerBackgroundColor,
//            colorInt(brandingProperties.getParticipantsStyle().getViewerBackgroundColor().value)
//        );
//        brandingProperties.getParticipantsStyle().setViewerBackgroundColor(new Color(colorHex(viewerBackgroundColor)));
//
//        String avatarRoundness = ta.getString(R.styleable.AttachParticipants_attach_participants_avatarBorderRadius);
//        if (!TextUtils.isEmpty(avatarRoundness)) {
//            brandingProperties.getParticipantsStyle().setAvatarBorderRadius(new BorderRadius(avatarRoundness));
//        }
//
//        ta.recycle();
//    }
//
//    private static void applyChatStyle(BrandingProperties brandingProperties, Context context, int chatStyleId) {
//        TypedArray ta = context.obtainStyledAttributes(chatStyleId, R.styleable.AttachChat);
//
//        int editorBackgroundColor = ta.getColor(
//            R.styleable.AttachChat_attach_chat_editorBackgroundColor,
//            colorInt(brandingProperties.getChatStyle().getEditorBackgroundColor().value)
//        );
//        brandingProperties.getChatStyle().setEditorBackgroundColor(new Color(colorHex(editorBackgroundColor)));
//
//        int viewerBackgroundColor = ta.getColor(
//            R.styleable.AttachChat_attach_chat_viewerBackgroundColor,
//            colorInt(brandingProperties.getChatStyle().getViewerBackgroundColor().value)
//        );
//        brandingProperties.getChatStyle().setViewerBackgroundColor(new Color(colorHex(viewerBackgroundColor)));
//
//        ta.recycle();
//    }
//
//    private static void applyVideoCallStyle(BrandingProperties brandingProperties, Context context, int styleId) {
//        TypedArray ta = context.obtainStyledAttributes(styleId, R.styleable.AttachVideoCall);
//
//        int focusBackgroundColor = ta.getColor(
//            R.styleable.AttachVideoCall_attach_videocall_focusBackgroundColor,
//            colorInt(brandingProperties.getVideoStyle().getFocusBackgroundColor().value)
//        );
//        brandingProperties.getVideoStyle().setFocusBackgroundColor(new Color(colorHex(focusBackgroundColor)));
//
//        int buttonBackgroundColor = ta.getColor(
//            R.styleable.AttachVideoCall_attach_videocall_buttonBackgroundColor,
//            colorInt(brandingProperties.getVideoStyle().getButtonBackgroundColor().value)
//        );
//        brandingProperties.getVideoStyle().setButtonBackgroundColor(new Color(colorHex(buttonBackgroundColor)));
//
//        ta.recycle();
//    }
//
//    private static boolean containsFlag(int flagSet, int flag) {
//        return (flagSet | flag) == flagSet;
//    }

    private static int getThemeAttr(Context context, int attr, int fallback) {
        final TypedValue value = new TypedValue();
        boolean resolved = context.getTheme().resolveAttribute(attr, value, true);
        if (!resolved) return fallback;
        return value.data;
    }

    private static int color(Context context, int id) {
        return ContextCompat.getColor(context, id);
    }

    private static String colorHex(int intColor) {
        return String.format("#%06X", (0xFFFFFF & intColor));
    }

    private static int colorInt(String strColor) {
        return android.graphics.Color.parseColor(strColor);
    }
}
