package live.attach.domain.model.video;

import java.util.ArrayList;
import java.util.List;

import live.attach.repackaged.com.google.gson.Gson;
import live.attach.domain.model.participant.Participant;

public class VideoCall {
    public enum State {INCOMING, OUTGOING, STOPPED, NONE, IN_PROGRESS}

    public enum ByeReason {INVITE_BUSY, INVITE_REJECT, INVITE_CANCEL, CALL_FINISH, INVITE_TIMEOUT, INVITE_ERROR} // TODO INVITE_ERROR not used, probably related to RoomSocketException?

    public final State state;
    public final Participant participant;
    public final ByeReason byeReason;
    public final List<IceServer> iceServers;

    public static VideoCall DEFAULT = new VideoCall(
        State.NONE,
        null,
        null,
        new ArrayList<>()
    );

    public VideoCall(State state, Participant participant, ByeReason byeReason, List<IceServer> iceServers) {
        this.state = state;
        this.participant = participant;
        this.byeReason = byeReason;
        this.iceServers = iceServers;
    }

    public VideoCall setState(State state) {
        return new VideoCall(
            state,
            this.participant,
            this.byeReason,
            this.iceServers
        );
    }

    public VideoCall setParticipant(Participant participant) {
        return new VideoCall(
            this.state,
            participant,
            this.byeReason,
            this.iceServers
        );
    }

    public VideoCall setByeReason(ByeReason byeReason) {
        return new VideoCall(
            this.state,
            this.participant,
            byeReason,
            this.iceServers
        );
    }

    public VideoCall setIceServers(List<IceServer> iceServers) {
        return new VideoCall(
            this.state,
            this.participant,
            this.byeReason,
            iceServers
        );
    }

    public boolean isActive() {
        return state == State.IN_PROGRESS || state == State.INCOMING || state == State.OUTGOING;
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
