package live.attach.domain.model.session;

import live.attach.repackaged.com.google.gson.Gson;

import live.attach.lib.TextUtils;
import live.attach.lib.com.auth0.android.jwt.JWT;

public class User {
    private String id;
    private String username;
    private String avatar;
    private String token;

    public static User initial = new User(null, null, null);
    public static User guest = new User("__guest__", null, null);

    public User(String id, String avatar, String username) {
        this.id = id;
        this.avatar = avatar;
        this.username = username;
    }

    public User(String token) {
        if (TextUtils.isEmpty(token)) {
            throw new IllegalArgumentException("'token' cannot be 'null' or empty.");
        }
        new JWT(token);
        this.id = null;
        this.username = null;
        this.avatar = null;
        this.token = token;
    }

    public boolean isGuest() {
        return "__guest__".equals(id);
    }

    public String getId() {
        return id;
    }

    public String getAvatar() {
        return avatar;
    }

    public String getUsername() {
        return username;
    }

    public boolean isJwtBased() {
        return !TextUtils.isEmpty(token);
    }

    public String getToken() {
        return token;
    }

    // Equals
    @Override
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof User)) return false;

        User that = (User) object;

        return id.equals(that.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
