package live.attach.domain.model.session;

import live.attach.domain.model.exception.AttachException;
import live.attach.domain.model.exception.error.AttachError;
import live.attach.domain.model.exception.error.SessionExpiredException;
import live.attach.domain.model.participant.Participant;
import live.attach.lib.EqualUtils;

public class Session {
    private final String token;
    private final String server;
    private final Participant currentParticipant;
    private final Application application;
    private AttachException exception;

    public static Session initial = new Session(null, null, null, null, null);

    public static Session error(AttachException error) {
        return new Session(null, null, null, null, error);
    }

    public static Session expired() {
        return error(new SessionExpiredException());
    }

    public static Session valid(String token, String server, Participant currentParticipant, Application application) {
        return new Session(token, server, currentParticipant, application, null);
    }

    private Session(String token, String server, Participant currentParticipant, Application application, AttachException error) {
        this.token = token;
        this.server = server;
        this.currentParticipant = currentParticipant;
        this.application = application;
        this.exception = error;
    }

    public boolean hasApplication() {
        return application != null;
    }

    public boolean isDevelopment() {
        return application != null && application.isDevelopment();
    }

    public boolean isGenuine() {
        return application != null && application.isGenuine();
    }

    public String getToken() {
        return token;
    }

    public String getServer() {
        return server;
    }

    public Participant getCurrentParticipant() {
        return currentParticipant;
    }

    public Application getApplication() {
        return application;
    }

    public AttachException getException() {
        return exception;
    }

    public boolean isValid() {
        return !(exception instanceof AttachError) && this != initial;
    }

    public boolean hasError() {
        return exception instanceof AttachError;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Session session = (Session) o;

        boolean exceptionsEqual = EqualUtils.equals(this.exception, session.exception);
        if (!exceptionsEqual) return false;

        return EqualUtils.equals(this.token, session.token);
    }
}
