package live.attach.domain.model.session;

import live.attach.domain.model.exception.error.AttachError;
import live.attach.domain.model.exception.AttachException;
import live.attach.domain.model.item.ItemId;
import live.attach.domain.model.participant.Participant;

public class RoomSession {
    private final Session session;
    private final String token;
    private final ItemId itemId;
    private final String server;
    private AttachException exception;

    private RoomSession(Session session, String token, ItemId itemId, String server, AttachException exception) {
        this.session = session;
        this.token = token;
        this.itemId = itemId;
        this.server = server;
        this.exception = exception;
    }

    public static RoomSession valid(Session session, String token, ItemId itemId, String server) {
        return new RoomSession(session, token, itemId, server, null);
    }

    public static RoomSession error(Session session, AttachException exception) {
        return new RoomSession(session, null, null, null, exception);
    }

    public Session getSession() {
        return session;
    }

    public String getToken() {
        return token;
    }

    public ItemId getItemId() {
        return itemId;
    }

    public String getServer() {
        return server;
    }

    public AttachException getException() {
        if (this.exception != null)
            return this.exception;
        else if (getSession() != null) {
            return getSession().getException();
        }
        return null;

    }

    public boolean hasError() {
        if (exception instanceof AttachError) return true;
        return getSession() != null && getSession().hasError();
    }

    public Participant getCurrentParticipant() {
        return session.getCurrentParticipant();
    }
}
