package live.attach.domain.model.session;

import live.attach.lib.EqualUtils;
import live.attach.domain.model.exception.AttachException;
import live.attach.domain.model.exception.error.AttachError;
import live.attach.domain.model.participant.Participant;

public class RoomPresence {
    public enum Status {OFFLINE, ONLINE, ERROR}

    private final Status status;
    private final AttachException exception;
    private final RoomSession roomSession;

    public static RoomPresence initial = new RoomPresence(null, Status.OFFLINE, null);

    private RoomPresence(RoomSession roomSession, Status status, AttachException exception) {
        this.roomSession = roomSession;
        this.status = status;
        this.exception = exception;
    }

    public static RoomPresence online(RoomSession roomSession) {
        return new RoomPresence(
            roomSession,
            Status.ONLINE,
            null
        );
    }

    public static RoomPresence offline(RoomSession roomSession) {
        return new RoomPresence(
            roomSession,
            Status.OFFLINE,
            null
        );
    }

    public static RoomPresence error(RoomSession roomSession, AttachException exception) {
        return new RoomPresence(
            roomSession,
            Status.ERROR,
            exception
        );
    }

    public boolean isActive() {
        return status == Status.ONLINE;
    }

    public Status getStatus() {
        return status;
    }

    public boolean hasError() {
        if (exception instanceof AttachError) return true;
        return roomSession != null && roomSession.hasError();
    }

    public AttachException getError() {
        if (this.exception != null) return exception;
        if (roomSession != null) return roomSession.getException();
        return null;
    }

    public Participant getCurrentParticipant() {
        return roomSession == null ? null : roomSession.getCurrentParticipant();
    }

    public RoomSession getRoomSession() {
        return roomSession;
    }

    @Override
    public String toString() {
        return "RoomPresence{" +
            "status=" + status +
            ", exception=" + getError() +
            '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        RoomPresence roomPresence = (RoomPresence) o;

        boolean exceptionEquals = EqualUtils.equals(getError(), roomPresence.getError());
        if (!exceptionEquals) return false;
        return this.status == roomPresence.status;

    }
}
