package live.attach.domain.model.item;


import live.attach.repackaged.com.google.gson.Gson;

public class ItemId {
    private final String provider;
    private final String type;
    private final String identifier;
    private final String url;

    public static final ItemId empty = new ItemId(null);

    public ItemId(String provider, String type, String identifier) {
        this.provider = provider;
        this.type = type;
        this.identifier = identifier;
        this.url = null;
    }

    public ItemId(String url) {
        this.url = url;
        this.provider = null;
        this.type = null;
        this.identifier = null;
    }

    public boolean isWebItem() {
        return url != null && url.length() > 0;
    }

    public String getProvider() {
        return provider;
    }

    public String getType() {
        return type;
    }

    public String getIdentifier() {
        return identifier;
    }

    public String getUrl() {
        return url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ItemId itemId = (ItemId) o;

        if (url != null) return url.equals(itemId.url);
        if (itemId.url != null) return false;

        if (provider == null && type == null && identifier == null) {
            return itemId.provider == null && itemId.type == null && itemId.identifier == null;
        }

        return provider.equals(itemId.provider) && type.equals(itemId.type) && identifier.equals(itemId.identifier);
    }

    @Override
    public int hashCode() {
        int result = provider != null ? provider.hashCode() : 0;
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (identifier != null ? identifier.hashCode() : 0);
        result = 31 * result + (url != null ? url.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }
}
