package live.attach.domain.model.exception.error;

import live.attach.sdk.R;
import live.attach.domain.model.exception.BannerException;

public class DebugVersionSocketException extends AttachError implements BannerException {

    public DebugVersionSocketException() {
        super("SDK_ROOM_HAS_EXPIRED");
    }

    @Override
    public int getIconRes() {
        return R.drawable.ic_vpn_key;
    }

    @Override
    public int getColorRes() {
        return R.color.error;
    }

    @Override
    public String getBannerMessage() {
        return "Rooms expire when using a development API key";
    }

    @Override
    public String getUrl() {
        return "/assist/debug";
    }
}
