package live.attach.domain.model.exception;

import live.attach.infrastructure.logger.AttachLogger;
import live.attach.infrastructure.logger.AttachLoggerFactory;
import live.attach.domain.model.exception.error.AttachInternalException;
import live.attach.domain.model.exception.error.DebugVersionSocketException;
import live.attach.domain.model.exception.error.NonGenuineVersionSocketException;
import live.attach.domain.model.exception.error.SessionExpiredException;
import live.attach.domain.model.exception.warning.AttachDetailedWarning;

public abstract class AttachException extends Exception {
    private static final AttachLogger log = AttachLoggerFactory.getLogger();

    public AttachException() {
    }

    public AttachException(String message) {
        super(message);
    }

    public AttachException(String message, Throwable cause) {
        super(message, cause);
    }

    public AttachException(Throwable cause) {
        super(cause);
    }


    public static AttachException exception(String error) {
        log.error("Socket error: " + error);
        switch (error) {
            // D1
            case "SENDER_TOO_MANY_INVITES":
            case "SENDER_TOO_MANY_CALLS_IN_PROGRESS":
            case "RECIPIENT_TOO_MANY_INVITES":
            case "RECIPIENT_TOO_MANY_CALLS_IN_PROGRESS":
                return new AttachDetailedWarning("SDK_TOO_MANY_CONSECUTIVE_CALLS") {
                };
            // D2
            case "INVITE_ALREADY_IN_PROGRESS":
            case "CALL_ALREADY_IN_PROGRESS":
                return new AttachDetailedWarning("SDK_CALL_IN_PROGRESS");
            // D3
            case "RECIPIENT_NOT_IN_ROOM":
                return new AttachDetailedWarning("SDK_RECIPIENT_NOT_IN_ROOM");
            // D4
            case "CALL_NOT_FOUND":
                return new AttachDetailedWarning("SDK_CALL_NOT_FOUND");
            // R2
            case "SERVER_ERROR":
            case "EXPIRED_TIMEOUT":
                return new SessionExpiredException();
            case "EXPIRED_NOT_GENUINE":
                return new NonGenuineVersionSocketException();
            case "EXPIRED_DEVELOPMENT":
                return new DebugVersionSocketException();
            // X1
            case "MISSING_PAYLOAD":
            case "INVALID_PAYLOAD":
            case "INVALID_JSON":
            case "UPDATED_USER_NOT_SAME_AS_SENDER":
            case "AVAILABLE_NOT_ALLOWED":
            case "OFFER_NOT_ALLOWED":
            case "ANSWER_NOT_ALLOWED":
            case "RECIPIENT_SAME_AS_SENDER":
            case "CALL_WITHOUT_INVITE":
            case "CALL_NOT_IN_PROGRESS":
            case "SENDER_NOT_IN_ROOM":
                return new AttachInternalException(new Exception(error));
            default:
                return new AttachInternalException(new Exception(error));
        }
    }
}
