package live.attach.domain.model.chat;

import java.util.Date;
import java.util.UUID;

import live.attach.domain.model.participant.Participant;
import live.attach.domain.model.session.User;

public class Message {
    public enum Category {CHAT, UNKNOWN}

    // id is set by the server, local messages have no id
    private String id;
    private User sender;
    private String body;
    private Long sentWhen;
    private Category category;

    public static Message localMessage(String message, Participant participant) {
        return new Message(
            UUID.randomUUID().toString(),
            new User(
                participant.getUserId(),
                participant.getAvatar(),
                participant.getUsername()
            ),
            message,
            new Date().getTime(),
            Message.Category.CHAT
        );
    }

    public Message(String id, User sender, String body, Long sentWhen, Category category) {
        this.id = id;
        this.sender = sender;
        this.body = body;
        this.sentWhen = sentWhen;
        this.category = category;
    }

    public Category getCategory() {
        return category;
    }

    public String getId() {
        return id;
    }

    public User getSender() {
        return sender;
    }

    public String getBody() {
        return body;
    }

    public Long getSentWhen() {
        return sentWhen;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Message message = (Message) o;
        return id.equals(message.id);
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}
