package live.attach.domain.model.chat;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class ChatHistory {
    public static Comparator<Message> DATE_COMPARATOR_ASC = (m1, m2) -> {
        long d1 = m1.getSentWhen();
        long d2 = m2.getSentWhen();
        return Long.compare(d2, d1);
    };

    private TreeSet<Message> messages;

    public static ChatHistory empty() {
        return new ChatHistory(new HashSet<>());
    }

    public ChatHistory(Collection<Message> messages) {
        this.messages = new TreeSet<>(DATE_COMPARATOR_ASC);
        this.messages.addAll(messages);
    }

    public void addMessages(Collection<Message> messages) {
        this.messages.addAll(messages);
    }

    public void addMessage(Message message) {
        this.messages.add(message);
    }

    public Set<Message> getMessages() {
        return messages;
    }

    public Long getOldestMessageDate() {
        if (messages.size() == 0) return null;

        return messages.last().getSentWhen();
    }
}
