package live.attach.domain.model.application;

import java.util.HashSet;
import java.util.Set;

public class OverlayServices {
    public enum OverlayService {VIDEOCALL, CHAT}

    private Set<OverlayService> overlayServices = new HashSet<>();

    public OverlayServices(Set<OverlayService> overlayServices) {
        this.overlayServices = overlayServices;
    }

    public boolean isVideocallEnabled() {
        return overlayServices.contains(OverlayService.VIDEOCALL);
    }

    public boolean isChatEnabled() {
        return overlayServices.contains(OverlayService.CHAT);
    }
}
