package live.attach.domain.model.application;

public class Color {
    private static final int BRIGHTNESS_LIMIT = 192 * 3;

    public static final Color BLACK = new Color("#000000");
    public static final Color WHITE = new Color("#FFFFFF");
    public static final Color GRAY = new Color("#D3D3D3");

    public static final Color DARK = new Color("#DE000000");
    public static final Color LIGHT = new Color("#FFFFFF");

    // "#XXX";
    public final String value;

    public Color(String value) {
        if (value == null) throw new RuntimeException("Color cannot be null");
        this.value = value;
    }

    public int getRed() {
        return Integer.valueOf(value.substring(1, 3), 16);
    }

    public int getGreen() {
        return Integer.valueOf(value.substring(3, 5), 16);
    }

    public int getBlue() {
        return Integer.valueOf(value.substring(5, 7), 16);
    }

    public boolean isLightColor() {
        return getRed() + getGreen() + getBlue() >= BRIGHTNESS_LIMIT;
    }

    public static Color getForegroundColor(Color backgroundColor) {
        return backgroundColor.isLightColor() ? Color.DARK : Color.LIGHT;
    }
}
