package live.attach.domain.model.application;

public class BorderRadius {

    public enum Roundness {ROUND, ROUNDED, SQUARE}

    public static final BorderRadius DEFAULT = new BorderRadius("round");

    private float value;

    public BorderRadius(Roundness roundness) {
        this(roundness.name().toLowerCase());
    }

    // > 0.5 = round
    // 0.5 = 50% = round
    // 0.125 = 12.5% = rounded
    // 0 = 0% = square
    // < 0 = square

    public BorderRadius(String value) {
        if (value == null) {
            this.value = 1f;
        } else if (value.equals("round")) {
            this.value = 1f;
        } else if (value.equals("rounded")) {
            this.value = 0.5f;
        } else if (value.equals("square")) {
            this.value = 0f;
        } else if (value.contains("%")) {
            this.value = parsePercentage(value);
        } else {
            this.value = parseFloat(value);
        }
    }

    private float parseFloat(String value) {
        try {
            float floatValue = Float.valueOf(value);
            if (floatValue >= 0.5f) return 1f;
            return floatValue / 0.5f;
        } catch (Exception e) {
            return 1f;
        }
    }

    private float parsePercentage(String value) {
        try {
            int percentage = Integer.valueOf(value.replaceAll("%", ""));
            if (percentage >= 50f) return 1f;
            return percentage / 50f;
        } catch (Exception e) {
            return 1f;
        }
    }

    public float getValue() {
        return value;
    }
}
