package live.attach.domain.model.application;

import live.attach.lib.EnumUtils;

import java.util.*;

public class AttachProperties {
    private static final String ATTACH_PRIMARY_COLOR = "#2E2F31";
    private static final String ATTACH_ACCENT_COLOR = "#707173";
    private static final String ATTACH_BACKGROUND_COLOR = "#FFFFFF";

    private static final String attachParticipantsAvatarBorderRadius = "attach:participants:avatar-border-radius";
    private static final String attachParticipantsFocusBackgroundColor = "attach:participants:focus-background-color";
    private static final String attachParticipantsViewerBackgroundColor = "attach:participants:viewer-background-color";

    private static final String attachVideocallButtonBackgroundColor = "attach:videocall:button-background-color";
    private static final String attachVideocallFocusBackgroundColor = "attach:videocall:focus-background-color";

    private static final String attachChatViewerBackgroundColor = "attach:chat:viewer-background-color";
    private static final String attachChatEditorBackgroundColor = "attach:chat:editor-background-color";

    public static final String attachOverlayServices = "attach:overlay:services";

    private Map<String, String> params;

    public AttachProperties() {
        this.params = new HashMap<>();
    }

    public AttachProperties(String primaryColor, String accentColor, String backgroundColor, String borderRadius) {
        this();
        params.put(attachParticipantsAvatarBorderRadius, borderRadius);
        params.put(attachParticipantsFocusBackgroundColor, primaryColor);
        params.put(attachParticipantsViewerBackgroundColor, backgroundColor);

        params.put(attachVideocallButtonBackgroundColor, accentColor);
        params.put(attachVideocallFocusBackgroundColor, primaryColor);

        params.put(attachChatViewerBackgroundColor, backgroundColor);
        params.put(attachChatEditorBackgroundColor, primaryColor);
    }

    public AttachProperties(Map<String, String> params) {
        this();
        this.params.putAll(params);
    }

    public Map<String, String> getAll() {
        return Collections.unmodifiableMap(params);
    }

    public AttachProperties set(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public AttachProperties merge(Map<String, String> params) {
        this.params.putAll(params);
        return this;
    }

    public AttachProperties merge(AttachProperties properties) {
        return this.merge(properties.params);
    }

    private String get(String key, String defaultValue) {
        if (this.params.containsKey(key)) return this.params.get(key);
        return defaultValue;
    }

    public BorderRadius getParticipantsAvatarBorderRadius() {
        return new BorderRadius(get(attachParticipantsAvatarBorderRadius, "round"));
    }

    public Color getParticipantsFocusBackgroundColor() {
        return new Color(get(attachParticipantsFocusBackgroundColor, ATTACH_PRIMARY_COLOR));
    }

    public Color getParticipantsViewerBackgroundColor() {
        return new Color(get(attachParticipantsViewerBackgroundColor, ATTACH_BACKGROUND_COLOR));
    }

    public Color getVideocallButtonBackgroundColor() {
        return new Color(get(attachVideocallButtonBackgroundColor, ATTACH_ACCENT_COLOR));
    }

    public Color getVideocallFocusBackgroundColor() {
        return new Color(get(attachVideocallFocusBackgroundColor, ATTACH_PRIMARY_COLOR));
    }

    public Color getChatViewerBackgroundColor() {
        return new Color(get(attachChatViewerBackgroundColor, ATTACH_BACKGROUND_COLOR));
    }

    public Color getChatEditorBackgroundColor() {
        return new Color(get(attachChatEditorBackgroundColor, ATTACH_PRIMARY_COLOR));
    }

    public OverlayServices getOverlayServices() {
        String overlayServices = get(attachOverlayServices, "videocall,chat");
        Set<String> overlayServicesSet = new HashSet<>(Arrays.asList((overlayServices.split(","))));
        return new OverlayServices(
                EnumUtils.mapAllToEnum(overlayServicesSet, OverlayServices.OverlayService.class)
        );
    }

    public boolean isVideocallEnabled() {
        return getOverlayServices().isVideocallEnabled();
    }

    public boolean isChatEnabled() {
        return getOverlayServices().isChatEnabled();
    }
}
