package live.attach.application;

import live.attach.repackaged.io.reactivex.Observable;
import live.attach.domain.model.session.RoomEvent;
import live.attach.domain.model.session.RoomPresence;
import live.attach.domain.model.session.RoomSession;
import live.attach.domain.model.video.Candidate;
import live.attach.domain.model.video.VideoCall;

public interface RoomLiveConnection {
    void connect(RoomSession roomSession);
    void disconnect();

    void requestParticipants();
    void requestMessages(Long timestamp);
    void sendMessage(String message);

    // Video
    void inviteParticipant(String socketId);
    void sendIceCandidate(String socketId, Candidate candidate);
    void sendAnswerCreated(String socketId, String patchedSessionDescription);
    void sendOfferCreated(String socketId, String patchedSessionDescription);
    void sendParticipantBye(String socketId, VideoCall.ByeReason reason);

    Observable<RoomPresence> getRoomPresence();
    Observable<RoomEvent> getRoomEvents();
}
