/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.testng;

import io.qameta.allure.AllureId;
import io.qameta.allure.testfilter.FileTestPlanSupplier;
import io.qameta.allure.testfilter.TestPlan;
import io.qameta.allure.testfilter.TestPlanUnknown;
import io.qameta.allure.testfilter.TestPlanV1_0;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.internal.ConstructorOrMethod;

public class AllureTestNgTestFilter
implements IMethodInterceptor {
    private final TestPlan testPlan;

    public AllureTestNgTestFilter() {
        this.testPlan = (TestPlan)new FileTestPlanSupplier().supply().orElse(new TestPlanUnknown());
    }

    public AllureTestNgTestFilter(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        return methods.stream().filter(this::isSelected).sorted(Comparator.comparing(IMethodInstance::getMethod, Comparator.nullsFirst(Comparator.comparingInt(ITestNGMethod::getPriority)))).collect(Collectors.toList());
    }

    public boolean isSelected(IMethodInstance instance) {
        return this.isSelected(instance.getMethod());
    }

    public boolean isSelected(ITestNGMethod method) {
        if (this.testPlan instanceof TestPlanV1_0) {
            return this.isSelected(method, (TestPlanV1_0)this.testPlan);
        }
        return true;
    }

    public boolean isSelected(ITestNGMethod testNGMethod, TestPlanV1_0 testPlan) {
        Optional<Method> method = Optional.ofNullable(testNGMethod).map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod);
        if (method.isPresent()) {
            String selector = this.getSelector(method.get());
            String allureId = method.filter(m -> m.isAnnotationPresent(AllureId.class)).map(m -> m.getAnnotation(AllureId.class)).map(AllureId::value).orElse(null);
            return testPlan.isSelected(allureId, selector);
        }
        return false;
    }

    private String getSelector(Method method) {
        return String.format("%s.%s", method.getDeclaringClass().getCanonicalName(), method.getName());
    }
}

