/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Statusable;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import lombok.Generated;

public class Statistic
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected long failed;
    protected long broken;
    protected long skipped;
    protected long passed;
    protected long unknown;

    @JsonProperty
    public long getTotal() {
        return this.getFailed() + this.getBroken() + this.getPassed() + this.getSkipped() + this.getUnknown();
    }

    @Deprecated
    @JsonProperty
    public void setTotal(long total) {
    }

    public long get(Status status) {
        switch (status) {
            case FAILED: {
                return this.getFailed();
            }
            case BROKEN: {
                return this.getBroken();
            }
            case PASSED: {
                return this.getPassed();
            }
            case SKIPPED: {
                return this.getSkipped();
            }
        }
        return this.getUnknown();
    }

    @JsonIgnore
    public Status getStatus() {
        for (Status status : Status.values()) {
            if (this.get(status) <= 0L) continue;
            return status;
        }
        return Status.UNKNOWN;
    }

    public void update(Statusable statusable) {
        if (Objects.isNull(statusable)) {
            return;
        }
        this.update(statusable.getStatus());
    }

    public void update(Status status) {
        if (Objects.isNull(status)) {
            return;
        }
        switch (status) {
            case FAILED: {
                this.setFailed(this.getFailed() + 1L);
                break;
            }
            case BROKEN: {
                this.setBroken(this.getBroken() + 1L);
                break;
            }
            case PASSED: {
                this.setPassed(this.getPassed() + 1L);
                break;
            }
            case SKIPPED: {
                this.setSkipped(this.getSkipped() + 1L);
                break;
            }
            default: {
                this.setUnknown(this.getUnknown() + 1L);
            }
        }
    }

    public void merge(Statistic other) {
        if (Objects.isNull(other)) {
            return;
        }
        this.setFailed(this.getFailed() + other.getFailed());
        this.setBroken(this.getBroken() + other.getBroken());
        this.setPassed(this.getPassed() + other.getPassed());
        this.setSkipped(this.getSkipped() + other.getSkipped());
        this.setUnknown(this.getUnknown() + other.getUnknown());
    }

    public static Comparator<Statistic> comparator() {
        return Comparator.comparing(Statistic::getFailed).thenComparing(Statistic::getBroken).thenComparing(Statistic::getPassed).thenComparing(Statistic::getSkipped).thenComparing(Statistic::getUnknown);
    }

    @Generated
    public Statistic() {
    }

    @Generated
    public long getFailed() {
        return this.failed;
    }

    @Generated
    public long getBroken() {
        return this.broken;
    }

    @Generated
    public long getSkipped() {
        return this.skipped;
    }

    @Generated
    public long getPassed() {
        return this.passed;
    }

    @Generated
    public long getUnknown() {
        return this.unknown;
    }

    @Generated
    public Statistic setFailed(long failed) {
        this.failed = failed;
        return this;
    }

    @Generated
    public Statistic setBroken(long broken) {
        this.broken = broken;
        return this;
    }

    @Generated
    public Statistic setSkipped(long skipped) {
        this.skipped = skipped;
        return this;
    }

    @Generated
    public Statistic setPassed(long passed) {
        this.passed = passed;
        return this;
    }

    @Generated
    public Statistic setUnknown(long unknown) {
        this.unknown = unknown;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Statistic)) {
            return false;
        }
        Statistic other = (Statistic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFailed() != other.getFailed()) {
            return false;
        }
        if (this.getBroken() != other.getBroken()) {
            return false;
        }
        if (this.getSkipped() != other.getSkipped()) {
            return false;
        }
        if (this.getPassed() != other.getPassed()) {
            return false;
        }
        return this.getUnknown() == other.getUnknown();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Statistic;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $failed = this.getFailed();
        result = result * 59 + (int)($failed >>> 32 ^ $failed);
        long $broken = this.getBroken();
        result = result * 59 + (int)($broken >>> 32 ^ $broken);
        long $skipped = this.getSkipped();
        result = result * 59 + (int)($skipped >>> 32 ^ $skipped);
        long $passed = this.getPassed();
        result = result * 59 + (int)($passed >>> 32 ^ $passed);
        long $unknown = this.getUnknown();
        result = result * 59 + (int)($unknown >>> 32 ^ $unknown);
        return result;
    }

    @Generated
    public String toString() {
        return "Statistic(failed=" + this.getFailed() + ", broken=" + this.getBroken() + ", skipped=" + this.getSkipped() + ", passed=" + this.getPassed() + ", unknown=" + this.getUnknown() + ")";
    }
}

