/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.internal.shadowed.jackson.databind.ser.impl;

import io.qameta.allure.internal.shadowed.jackson.core.JsonGenerator;
import io.qameta.allure.internal.shadowed.jackson.core.io.SerializedString;
import io.qameta.allure.internal.shadowed.jackson.databind.BeanProperty;
import io.qameta.allure.internal.shadowed.jackson.databind.JavaType;
import io.qameta.allure.internal.shadowed.jackson.databind.JsonMappingException;
import io.qameta.allure.internal.shadowed.jackson.databind.JsonNode;
import io.qameta.allure.internal.shadowed.jackson.databind.JsonSerializer;
import io.qameta.allure.internal.shadowed.jackson.databind.SerializerProvider;
import io.qameta.allure.internal.shadowed.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.qameta.allure.internal.shadowed.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import io.qameta.allure.internal.shadowed.jackson.databind.node.ObjectNode;
import io.qameta.allure.internal.shadowed.jackson.databind.ser.BeanPropertyWriter;
import io.qameta.allure.internal.shadowed.jackson.databind.ser.impl.PropertySerializerMap;
import io.qameta.allure.internal.shadowed.jackson.databind.ser.impl.UnwrappingBeanSerializer;
import io.qameta.allure.internal.shadowed.jackson.databind.util.NameTransformer;
import java.io.Serializable;
import java.util.Map;

public class UnwrappingBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final NameTransformer _nameTransformer;

    public UnwrappingBeanPropertyWriter(BeanPropertyWriter base, NameTransformer unwrapper) {
        super(base);
        this._nameTransformer = unwrapper;
    }

    protected UnwrappingBeanPropertyWriter(UnwrappingBeanPropertyWriter base, NameTransformer transformer, SerializedString name) {
        super((BeanPropertyWriter)base, name);
        this._nameTransformer = transformer;
    }

    @Override
    public UnwrappingBeanPropertyWriter rename(NameTransformer transformer) {
        String oldName = this._name.getValue();
        String newName = transformer.transform(oldName);
        transformer = NameTransformer.chainedTransformer(transformer, this._nameTransformer);
        return this._new(transformer, new SerializedString(newName));
    }

    protected UnwrappingBeanPropertyWriter _new(NameTransformer transformer, SerializedString newName) {
        return new UnwrappingBeanPropertyWriter(this, transformer, newName);
    }

    @Override
    public boolean isUnwrapping() {
        return true;
    }

    @Override
    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.get(bean);
        if (value == null) {
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
            return;
        }
        if (!ser.isUnwrappingSerializer()) {
            gen.writeFieldName(this._name);
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, gen, prov);
        } else {
            ser.serializeWithType(value, gen, prov, this._typeSerializer);
        }
    }

    @Override
    public void assignSerializer(JsonSerializer<Object> ser) {
        if (ser != null) {
            NameTransformer t = this._nameTransformer;
            if (ser.isUnwrappingSerializer() && ser instanceof UnwrappingBeanSerializer) {
                t = NameTransformer.chainedTransformer(t, ((UnwrappingBeanSerializer)ser)._nameTransformer);
            }
            ser = ser.unwrappingSerializer(t);
        }
        super.assignSerializer(ser);
    }

    @Override
    public void depositSchemaProperty(final JsonObjectFormatVisitor visitor, SerializerProvider provider) throws JsonMappingException {
        JsonSerializer<Object> ser = provider.findValueSerializer(this.getType(), (BeanProperty)this).unwrappingSerializer(this._nameTransformer);
        if (ser.isUnwrappingSerializer()) {
            ser.acceptJsonFormatVisitor(new JsonFormatVisitorWrapper.Base(provider){

                @Override
                public JsonObjectFormatVisitor expectObjectFormat(JavaType type) throws JsonMappingException {
                    return visitor;
                }
            }, this.getType());
        } else {
            super.depositSchemaProperty(visitor, provider);
        }
    }

    @Override
    protected void _depositSchemaProperty(ObjectNode propertiesNode, JsonNode schemaNode) {
        JsonNode props = schemaNode.get("properties");
        if (props != null) {
            for (Map.Entry<String, JsonNode> entry : props.properties()) {
                String name = entry.getKey();
                if (this._nameTransformer != null) {
                    name = this._nameTransformer.transform(name);
                }
                propertiesNode.set(name, entry.getValue());
            }
        }
    }

    @Override
    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        JsonSerializer<Object> serializer;
        if (this._nonTrivialBaseType != null) {
            JavaType subtype = provider.constructSpecializedType(this._nonTrivialBaseType, type);
            serializer = provider.findValueSerializer(subtype, (BeanProperty)this);
        } else {
            serializer = provider.findValueSerializer(type, (BeanProperty)this);
        }
        NameTransformer t = this._nameTransformer;
        if (serializer.isUnwrappingSerializer() && serializer instanceof UnwrappingBeanSerializer) {
            t = NameTransformer.chainedTransformer(t, ((UnwrappingBeanSerializer)serializer)._nameTransformer);
        }
        serializer = serializer.unwrappingSerializer(t);
        this._dynamicSerializers = this._dynamicSerializers.newWith(type, serializer);
        return serializer;
    }
}

