/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.detect;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public final class WellKnownFileExtensionsUtils {
    public static final Map<String, String> EXT_TO_MIME_TYPE;
    public static final Map<String, String> MIME_TYPE_TO_EXT;

    private WellKnownFileExtensionsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String lookup(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (Objects.isNull(extension) || extension.isEmpty()) {
            return null;
        }
        return EXT_TO_MIME_TYPE.get(extension);
    }

    public static String getExtensionByMimeType(String contentType) {
        if ("application/octet-stream".equals(contentType)) {
            return "";
        }
        return MIME_TYPE_TO_EXT.getOrDefault(contentType, "");
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("svg", "image/svg+xml");
        m.put("jpg", "image/jpeg");
        m.put("txt", "text/plain");
        m.put("zip", "application/zip");
        m.put("png", "image/png");
        m.put("tgz", "application/gzip");
        m.put("json", "application/json");
        m.put("xml", "application/xml");
        m.put("mp3", "audio/mpeg");
        m.put("mp4", "video/mp4");
        m.put("webm", "video/webm");
        m.put("tar", "application/x-tar");
        m.put("gtar", "application/x-gtar");
        m.put("urls", "text/uri-list");
        m.put("ogv", "video/ogg");
        m.put("tsv", "text/tab-separated-values");
        m.put("csv", "text/csv");
        m.put("html", "text/html");
        m.put("yaml", "text/x-yaml");
        m.put("tiff", "image/tiff");
        m.put("bmp", "image/bmp");
        m.put("webp", "image/webp");
        m.put("xdp", "application/vnd.adobe.xdp+xml");
        m.put("osf", "application/vnd.yamaha.openscoreformat");
        m.put("mod", "audio/x-mod");
        m.put("xdm", "application/vnd.syncml.dm+xml");
        m.put("qwd", "application/vnd.quark.quarkxpress");
        m.put("mcurl", "text/vnd.curl.mcurl");
        m.put("xdw", "application/vnd.fujixerox.docuworks");
        m.put("patch", "text/x-diff");
        m.put("sas7baud", "application/x-sas-audit");
        m.put("xmind", "application/x-xmind");
        m.put("types", "text/plain");
        m.put("ifo", "application/x-dvd-ifo");
        m.put("vmdk", "application/x-vmdk");
        m.put("ifm", "application/vnd.shana.informed.formdata");
        m.put("distz", "application/octet-stream");
        m.put("mp2", "audio/mpeg");
        m.put("mny", "application/x-msmoney");
        m.put("oti", "application/vnd.oasis.opendocument.image-template");
        m.put("nitf", "image/nitf");
        m.put("mpg", "video/mpeg");
        m.put("xer", "application/patch-ops-error+xml");
        m.put("qxl", "application/vnd.quark.quarkxpress");
        m.put("otg", "application/vnd.oasis.opendocument.graphics-template");
        m.put("mpe", "video/mpeg");
        m.put("oth", "application/vnd.oasis.opendocument.text-web");
        m.put("zir", "application/vnd.zul");
        m.put("mpc", "application/vnd.mophun.certificate");
        m.put("mpd", "application/dash+xml");
        m.put("otf", "application/x-font-otf");
        m.put("otc", "application/vnd.oasis.opendocument.chart-template");
        m.put("mpp", "application/vnd.ms-project");
        m.put("qxt", "application/vnd.quark.quarkxpress");
        m.put("mpm", "application/vnd.blueice.multipass");
        m.put("mpn", "application/vnd.mophun.application");
        m.put("otp", "application/vnd.oasis.opendocument.presentation-template");
        m.put("otm", "application/vnd.oasis.opendocument.text-master");
        m.put("pcap", "application/vnd.tcpdump.pcap");
        m.put("mobi", "application/x-mobipocket-ebook");
        m.put("odft", "application/vnd.oasis.opendocument.formula-template");
        m.put("mov", "video/quicktime");
        m.put("xslt", "application/xslt+xml");
        m.put("igs", "model/iges");
        m.put("ost", "application/vnd.ms-outlook-pst");
        m.put("mos", "image/x-raw-leaf");
        m.put("igl", "application/vnd.igloader");
        m.put("qwt", "application/vnd.quark.quarkxpress");
        m.put("qxd", "application/vnd.quark.quarkxpress");
        m.put("igx", "application/vnd.micrografx.igx");
        m.put("qxb", "application/vnd.quark.quarkxpress");
        m.put("hprof", "application/vnd.java.hprof");
        m.put("mseed", "application/vnd.fdsn.mseed");
        m.put("djvu", "image/vnd.djvu");
        m.put("cdbcmsg", "application/vnd.contact.cmsg");
        m.put("mmap", "application/vnd.mindjet.mindmanager");
        m.put("kml", "application/vnd.google-earth.kml+xml");
        m.put("webarchive", "application/x-webarchive");
        m.put("jnlp", "application/x-java-jnlp-file");
        m.put("iif", "application/vnd.shana.informed.interchange");
        m.put("vbs", "text/x-vbscript");
        m.put("mpx", "application/x-project");
        m.put("mpt", "application/vnd.ms-project");
        m.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        m.put("ott", "application/vnd.oasis.opendocument.text-template");
        m.put("gdl", "model/vnd.gdl");
        m.put("mpy", "application/vnd.ibm.minipay");
        m.put("kne", "application/vnd.kinar");
        m.put("mrc", "application/marc");
        m.put("ccxml", "application/ccxml+xml");
        m.put("knp", "application/vnd.kinar");
        m.put("vcx", "application/vnd.vcx");
        m.put("config", "text/x-config");
        m.put("vcs", "text/x-vcalendar");
        m.put("mqy", "application/vnd.mobius.mqy");
        m.put("m14", "application/x-msmediaview");
        m.put("geo", "application/vnd.dynageo");
        m.put("iiq", "image/x-raw-phaseone");
        m.put("m13", "application/x-msmediaview");
        m.put("maker", "application/vnd.framemaker");
        m.put("gex", "application/vnd.geometry-explorer");
        m.put("vcg", "application/vnd.groove-vcard");
        m.put("kmz", "application/vnd.google-earth.kmz");
        m.put("less", "text/x-less");
        m.put("vcf", "text/x-vcard");
        m.put("ear", "application/x-tika-java-enterprise-archive");
        m.put("vcd", "application/x-cdlink");
        m.put("owl", "application/rdf+xml");
        m.put("pages", "application/vnd.apple.pages");
        m.put("xht", "application/xhtml+xml");
        m.put("ggb", "application/vnd.geogebra.file");
        m.put("msh", "model/mesh");
        m.put("msi", "application/x-ms-installer");
        m.put("msf", "application/vnd.epson.msf");
        m.put("msg", "application/vnd.ms-outlook");
        m.put("asciidoc", "text/x-asciidoc");
        m.put("dataless", "application/vnd.fdsn.seed");
        m.put("kon", "application/vnd.kde.kontour");
        m.put("msp", "application/x-ms-installer");
        m.put("h261", "video/h261");
        m.put("h263", "video/h263");
        m.put("msl", "application/vnd.mobius.msl");
        m.put("spot", "text/vnd.in3d.spot");
        m.put("h264", "video/h264");
        m.put("mrw", "image/x-raw-minolta");
        m.put("vda", "image/x-tga");
        m.put("musicxml", "application/vnd.recordare.musicxml+xml");
        m.put("msa", "application/vnd.msa-disk-image");
        m.put("ghf", "application/vnd.groove-help");
        m.put("tao", "application/vnd.tao.intent-module-archive");
        m.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
        m.put("onetoc2", "application/onenote; format=onetoc2");
        m.put("mts", "model/vnd.mts");
        m.put("kpr", "application/vnd.kde.kpresenter");
        m.put("oxt", "application/vnd.openofficeorg.extension");
        m.put("sas7bput", "application/x-sas-putility");
        m.put("ggt", "application/vnd.geogebra.tool");
        m.put("xif", "image/vnd.xiff");
        m.put("m1v", "video/mpeg");
        m.put("iso19139", "text/iso19139+xml");
        m.put("mst", "application/x-ms-installer");
        m.put("m2a", "audio/mpeg");
        m.put("mathml", "application/mathml+xml");
        m.put("zmm", "application/vnd.handheld-entertainment+xml");
        m.put("mseq", "application/vnd.mseq");
        m.put("minigsf", "audio/x-psf");
        m.put("cab", "application/vnd.ms-cab-compressed");
        m.put("sas7bfdb", "application/x-sas-fdb");
        m.put("gif", "image/gif");
        m.put("wbxml", "application/vnd.wap.wbxml");
        m.put("imp", "application/vnd.accpac.simply.imp");
        m.put("tbz", "application/x-bzip");
        m.put("atom", "application/atom+xml");
        m.put("shar", "application/x-shar");
        m.put("Cbl", "text/x-cobol");
        m.put("gim", "application/vnd.groove-identity-message");
        m.put("mus", "application/vnd.musician");
        m.put("caf", "audio/x-caf");
        m.put("xtest", "text/plain");
        m.put("ac", "text/plain");
        m.put("ad", "text/x-asciidoc");
        m.put("m2v", "video/mpeg");
        m.put("ai", "application/illustrator");
        m.put("edm", "application/vnd.novadigm.edm");
        m.put("kpt", "application/vnd.kde.kpresenter");
        m.put("aj", "text/x-aspectj");
        m.put("al", "text/x-perl");
        m.put("scala", "text/x-scala");
        m.put("am", "text/plain");
        m.put("m3a", "audio/mpeg");
        m.put("edx", "application/vnd.novadigm.edx");
        m.put("ar", "application/x-archive");
        m.put("as", "text/x-actionscript");
        m.put("ini", "text/x-ini");
        m.put("au", "audio/basic");
        m.put("aw", "application/applixware");
        m.put("m4s", "video/iso.segment");
        m.put("xla", "application/vnd.ms-excel");
        m.put("cbl", "text/x-cobol");
        m.put("car", "application/vnd.curl.car");
        m.put("cap", "application/vnd.tcpdump.pcap");
        m.put("ims", "application/vnd.ms-ims");
        m.put("m3u", "audio/x-mpegurl");
        m.put("tcl", "text/x-tcl");
        m.put("zoo", "application/x-zoo");
        m.put("m4a", "audio/mp4");
        m.put("m4b", "audio/mp4");
        m.put("handlers", "text/plain");
        m.put("mvb", "application/x-msmediaview");
        m.put("cat", "application/vnd.ms-pki.seccat");
        m.put("br", "application/x-brotli");
        m.put("xlw", "application/vnd.ms-excel");
        m.put("atomcat", "application/atomcat+xml");
        m.put("xlt", "application/vnd.ms-excel");
        m.put("bz", "application/x-bzip");
        m.put("xlr", "application/x-tika-msworks-spreadsheet");
        m.put("xls", "application/vnd.ms-excel");
        m.put("lostxml", "application/lost+xml");
        m.put("ksp", "application/vnd.kde.kspread");
        m.put("cc", "text/x-c++src");
        m.put("xlz", "application/x-xliff+zip");
        m.put("vhd", "text/x-vhdl");
        m.put("xlf", "application/x-xliff+xml");
        m.put("inx", "application/x-adobe-indesign-interchange");
        m.put("BAS", "text/x-basic");
        m.put("xld", "application/vnd.ms-excel");
        m.put("warc", "application/warc");
        m.put("k25", "image/x-raw-kodak");
        m.put("m4u", "video/vnd.mpegurl");
        m.put("xlc", "application/vnd.ms-excel");
        m.put("cl", "text/x-common-lisp");
        m.put("m4v", "video/x-m4v");
        m.put("mwf", "application/vnd.mfer");
        m.put("xll", "application/vnd.ms-excel");
        m.put("xlm", "application/vnd.ms-excel");
        m.put("cs", "text/x-csharp");
        m.put("cu", "application/cu-seeme");
        m.put("ipk", "application/vnd.shana.informed.package");
        m.put("ras", "image/x-cmu-raster");
        m.put("cdf", "application/x-netcdf");
        m.put("sas7bndx", "application/x-sas-data-index");
        m.put("rar", "application/x-rar-compressed");
        m.put("viv", "video/vnd.vivo");
        m.put("vis", "application/vnd.visionary");
        m.put("cda", "application/x-cdf");
        m.put("mxl", "application/vnd.recordare.musicxml");
        m.put("aart", "text/plain");
        m.put("ram", "audio/x-pn-realaudio");
        m.put("fh11", "image/x-freehand");
        m.put("fh12", "image/x-freehand");
        m.put("mxu", "video/vnd.mpegurl");
        m.put("mxs", "application/vnd.triscape.mxs");
        m.put("raw", "image/x-raw-panasonic");
        m.put("ktr", "application/vnd.kahootz");
        m.put("tex", "application/x-tex");
        m.put("cct", "application/x-director");
        m.put("ei6", "application/vnd.pg.osasli");
        m.put("cpio", "application/x-cpio");
        m.put("parquet", "application/x-parquet");
        m.put("fh10", "image/x-freehand");
        m.put("do", "application/x-stata-do");
        m.put("dp", "application/vnd.osgi.dp");
        m.put("ipa", "application/x-itunes-ipa");
        m.put("mxf", "application/mxf");
        m.put("xmp", "application/rdf+xml");
        m.put("egrm", "text/plain");
        m.put("gram", "application/srgs");
        m.put("raf", "image/x-raw-fuji");
        m.put("davmount", "application/davmount+xml");
        m.put("xwelcome", "text/plain");
        m.put("aab", "application/x-authorware-bin");
        m.put("aac", "audio/x-aac");
        m.put("aam", "application/x-authorware-map");
        m.put("cel", "image/vnd.dgn");
        m.put("HPP", "text/x-c++hdr");
        m.put("fe_launch", "application/vnd.denovo.fcselayout-link");
        m.put("fh40", "image/x-freehand");
        m.put("cdr", "application/coreldraw");
        m.put("ktz", "application/vnd.kahootz");
        m.put("el", "text/x-emacs-lisp");
        m.put("ecma", "application/ecmascript");
        m.put("g3", "image/g3fax");
        m.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
        m.put("tfm", "application/x-tex-tfm");
        m.put("cdy", "application/vnd.cinderella");
        m.put("cdx", "chemical/x-cdx");
        m.put("irm", "application/vnd.ibm.rights-management");
        m.put("cfg", "text/x-config");
        m.put("msty", "application/vnd.muvee.style");
        m.put("ez", "application/andrew-inset");
        m.put("cfc", "text/x-coldfusion");
        m.put("cfm", "text/x-coldfusion");
        m.put("gp4", "application/x-guitar-pro");
        m.put("wasm", "application/wasm");
        m.put("irp", "application/vnd.irepository.package+xml");
        m.put("fh", "image/x-freehand");
        m.put("gmx", "application/vnd.gmx");
        m.put("aas", "application/x-authorware-seg");
        m.put("cer", "application/pkix-cert");
        m.put("fm", "application/vnd.framemaker");
        m.put("ac3", "audio/ac3");
        m.put("tga", "image/x-tga");
        m.put("fn", "text/plain");
        m.put("fo", "application/xslfo+xml");
        m.put("zst", "application/zstd");
        m.put("h5", "application/x-hdf");
        m.put("ft", "text/plain");
        m.put("xop", "application/xop+xml");
        m.put("fv", "text/plain");
        m.put("nroff", "text/troff");
        m.put("iso", "application/x-iso9660-image");
        m.put("cgi", "text/x-cgi");
        m.put("ace", "application/x-ace-compressed");
        m.put("xpx", "application/vnd.intercon.formnet");
        m.put("acc", "application/vnd.americandynamics.acc");
        m.put("classpath", "text/plain");
        m.put("xpw", "application/vnd.intercon.formnet");
        m.put("rdz", "application/vnd.data-vision.rdz");
        m.put("kwt", "application/vnd.kde.kword");
        m.put("cgm", "image/cgm");
        m.put("rdf", "application/rdf+xml");
        m.put("vstx", "application/vnd.ms-visio.template");
        m.put("xpm", "image/x-xpixmap");
        m.put("dump", "application/octet-stream");
        m.put("xpi", "application/x-xpinstall");
        m.put("go", "text/x-go");
        m.put("xpt", "application/x-sas-xport");
        m.put("i3", "text/x-modula");
        m.put("xpr", "application/vnd.is-xpr");
        m.put("xps", "application/vnd.ms-xpsdocument");
        m.put("vstm", "application/vnd.ms-visio.template.macroenabled.12");
        m.put("kwd", "application/vnd.kde.kword");
        m.put("gv", "text/vnd.graphviz");
        m.put("abw", "application/x-abiword");
        m.put("xspf", "application/xspf+xml");
        m.put("itp", "application/vnd.shana.informed.formtemplate");
        m.put("gz", "application/gzip");
        m.put("pas", "text/x-pascal");
        m.put("adf", "application/x-amiga-disk-format");
        m.put("res", "application/x-dtbresource+xml");
        m.put("itk", "text/x-tcl");
        m.put("gpg", "application/pgp-encrypted");
        m.put("ada", "text/x-ada");
        m.put("gph", "application/vnd.flographit");
        m.put("adb", "text/x-ada");
        m.put("adp", "audio/adpcm");
        m.put("tbz2", "application/x-bzip2");
        m.put("chm", "application/vnd.ms-htmlhelp");
        m.put("frame", "application/vnd.framemaker");
        m.put("hh", "text/x-c++hdr");
        m.put("vssx", "application/vnd.ms-visio.stencil");
        m.put("acu", "application/vnd.acucobol");
        m.put("tif", "image/tiff");
        m.put("hp", "text/x-c++hdr");
        m.put("elc", "application/octet-stream");
        m.put("pam", "image/x-portable-arbitrarymap");
        m.put("rep", "application/vnd.businessobjects");
        m.put("hs", "text/x-haskell");
        m.put("mmat", "application/vnd.mindjet.mindmanager");
        m.put("vssm", "application/vnd.ms-visio.stencil.macroenabled.12");
        m.put("mmas", "application/vnd.mindjet.mindmanager");
        m.put("hx", "text/x-haxe");
        m.put("eml", "message/rfc822");
        m.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
        m.put("iges", "model/iges");
        m.put("cif", "chemical/x-cif");
        m.put("emf", "image/emf");
        m.put("aep", "application/vnd.adobe.aftereffects.project");
        m.put("rgb", "image/x-rgb");
        m.put("ig", "text/x-modula");
        m.put("m3u8", "application/vnd.apple.mpegurl");
        m.put("gqs", "application/vnd.grafeq");
        m.put("xsd", "application/xml");
        m.put("cil", "application/vnd.ms-artgalry");
        m.put("grb1", "application/x-grib");
        m.put("grb2", "application/x-grib");
        m.put("pbd", "application/vnd.powerbuilder6");
        m.put("xmap", "text/plain");
        m.put("in", "text/plain");
        m.put("docm", "application/vnd.ms-word.document.macroenabled.12");
        m.put("ads", "text/x-ada");
        m.put("mbox", "application/mbox");
        m.put("gqf", "application/vnd.grafeq");
        m.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        m.put("pbm", "image/x-portable-bitmap");
        m.put("gnucash", "application/x-gnucash");
        m.put("pcx", "image/vnd.zbrush.pcx");
        m.put("grm", "text/plain");
        m.put("ivp", "application/vnd.immervision-ivp");
        m.put("pct", "image/x-pict");
        m.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
        m.put("vox", "application/x-authorware-bin");
        m.put("applescript", "text/x-applescript");
        m.put("tld", "text/plain");
        m.put("java", "text/x-java-source");
        m.put("ens", "application/x-endnote-style");
        m.put("grv", "application/vnd.groove-injector");
        m.put("afp", "application/vnd.ibm.modcap");
        m.put("ent", "text/plain");
        m.put("ivu", "application/vnd.immervision-ivu");
        m.put("afm", "application/x-font-adobe-metric");
        m.put("sfdu", "application/x-sfdu");
        m.put("enr", "application/x-endnote-refer");
        m.put("slddrw", "application/sldworks");
        m.put("jl", "text/x-common-lisp");
        m.put("ptid", "application/vnd.pvi.ptid1");
        m.put("xsp", "text/plain");
        m.put("xsm", "application/vnd.syncml+xml");
        m.put("emz", "image/x-emf-compressed");
        m.put("pcf", "application/x-font-pcf");
        m.put("aet", "application/vnd.adobe.aftereffects.template");
        m.put("xsl", "application/xml");
        m.put("js", "application/javascript");
        m.put("gre", "application/vnd.geometry-explorer");
        m.put("pack", "application/x-java-pack200");
        m.put("jx", "text/plain");
        m.put("pcl", "application/vnd.hp-pcl");
        m.put("vor", "application/x-staroffice-template");
        m.put("x32", "application/x-authorware-bin");
        m.put("grb", "application/x-grib");
        m.put("eol", "audio/vnd.digital-winds");
        m.put("c++", "text/x-c++src");
        m.put("properties", "text/x-java-properties");
        m.put("mp4a", "audio/mp4");
        m.put("FRM", "text/x-vbasic");
        m.put("xhtml2", "application/xhtml+xml");
        m.put("Cls", "text/x-vbasic");
        m.put("eot", "application/vnd.ms-fontobject");
        m.put("x3f", "image/x-raw-sigma");
        m.put("x3d", "application/vnd.hzn-3d-crossword");
        m.put("jnilib", "application/x-java-jnilib");
        m.put("pdf", "application/pdf");
        m.put("m3", "text/x-modula");
        m.put("m4", "text/plain");
        m.put("enw", "application/x-endnote-refer");
        m.put("pdb", "chemical/x-pdb");
        m.put("gsf", "application/x-font-ghostscript");
        m.put("ft10", "image/x-freehand");
        m.put("gtm", "application/vnd.groove-tool-message");
        m.put("ft11", "image/x-freehand");
        m.put("ft12", "image/x-freehand");
        m.put("clj", "text/x-clojure");
        m.put("nar", "application/vnd.iptc.g2.newsmessage+xml");
        m.put("semf", "application/vnd.semf");
        m.put("tmx", "application/x-tmx");
        m.put("pfb", "application/x-font-type1");
        m.put("semd", "application/vnd.semd");
        m.put("sema", "application/vnd.sema");
        m.put("gtw", "model/vnd.gtw");
        m.put("cls", "text/x-vbasic");
        m.put("pfa", "application/x-font-type1");
        m.put("eps", "application/postscript");
        m.put("htke", "application/vnd.kenameaapp");
        m.put("class", "application/java-vm");
        m.put("flac", "audio/x-flac");
        m.put("clp", "application/x-msclip");
        m.put("n3", "text/plain");
        m.put("pef", "image/x-raw-pentax");
        m.put("sitx", "application/x-stuffitx");
        m.put("rif", "application/reginfo+xml");
        m.put("xul", "application/vnd.mozilla.xul+xml");
        m.put("xlog", "text/plain");
        m.put("mp2a", "audio/mpeg");
        m.put("cla", "application/vnd.claymore");
        m.put("lz", "application/x-lzip");
        m.put("pem", "application/x-x509-cert; format=pem");
        m.put("pen", "text/plain");
        m.put("tmo", "application/vnd.tmobile-livetv");
        m.put("es3", "application/vnd.eszigno3+xml");
        m.put("xwd", "image/x-xwindowdump");
        m.put("ma", "application/mathematica");
        m.put("pfx", "application/x-pkcs12");
        m.put("cml", "chemical/x-cml");
        m.put("mb", "application/mathematica");
        m.put("md", "text/x-web-markdown");
        m.put("aif", "audio/x-aiff");
        m.put("me", "text/troff");
        m.put("mf", "text/plain");
        m.put("mg", "text/x-modula");
        m.put("air", "application/vnd.adobe.air-application-installer-package+zip");
        m.put("link66", "application/vnd.route66.link66+xml");
        m.put("vsf", "application/vnd.vsf");
        m.put("ml", "text/x-ml");
        m.put("cmp", "application/vnd.yellowriver-custom-menu");
        m.put("vsd", "application/vnd.visio");
        m.put("onepkg", "application/onenote; format=package");
        m.put("ms", "text/troff");
        m.put("bcpio", "application/x-bcpio");
        m.put("roff", "text/troff");
        m.put("pcapng", "application/vnd.tcpdump.pcapng");
        m.put("xvm", "application/xv+xml");
        m.put("pfr", "application/font-tdpfr");
        m.put("sas7bdmd", "application/x-sas-dmdb");
        m.put("cmd", "application/x-bat");
        m.put("sv4cpio", "application/x-sv4cpio");
        m.put("cmc", "application/vnd.cosmocaller");
        m.put("gnumeric", "application/x-gnumeric");
        m.put("pfm", "application/x-font-printer-metric");
        m.put("et3", "application/vnd.eszigno3+xml");
        m.put("nb", "application/mathematica");
        m.put("ditaval", "application/dita+xml; format=val");
        m.put("ncx", "application/x-dtbncx+xml");
        m.put("nc", "application/x-netcdf");
        m.put("erl", "text/x-erlang");
        m.put("mp4v", "video/mp4");
        m.put("rld", "application/resource-lists-diff+xml");
        m.put("mp4s", "application/mp4");
        m.put("lzma", "application/x-lzma");
        m.put("rlc", "image/vnd.fujixerox.edmics-rlc");
        m.put("xroles", "text/plain");
        m.put("data", "text/plain");
        m.put("cmx", "image/x-cmx");
        m.put("vsl", "text/plain");
        m.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
        m.put("vsw", "application/vnd.visio");
        m.put("pgp", "application/pgp-encrypted");
        m.put("erf", "image/x-raw-epson");
        m.put("cnd", "text/plain");
        m.put("Cob", "text/x-cobol");
        m.put("vss", "application/vnd.visio");
        m.put("pgm", "image/x-portable-graymap");
        m.put("vst", "application/vnd.visio");
        m.put("pgn", "application/x-chess-pgn");
        m.put("com", "application/x-msdownload");
        m.put("mhtml", "multipart/related");
        m.put("pic", "image/x-pict");
        m.put("tpl", "application/vnd.groove-tool-template");
        m.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
        m.put("esf", "application/vnd.epson.esf");
        m.put("cod", "application/vnd.rim.cod");
        m.put("tpt", "application/vnd.trid.tpt");
        m.put("php", "text/x-php");
        m.put("vtt", "text/vtt");
        m.put("cob", "text/x-cobol");
        m.put("vtu", "model/vnd.vtu");
        m.put("sgml", "text/sgml");
        m.put("cr3", "image/x-canon-cr3");
        m.put("laz", "application/x-asprs");
        m.put("tra", "application/vnd.trueapp");
        m.put("aiff", "audio/x-aiff");
        m.put("cr2", "image/x-canon-cr2");
        m.put("cpp", "text/x-c++src");
        m.put("las", "application/x-asprs");
        m.put("aifc", "audio/x-aiff");
        m.put("pl", "text/x-perl");
        m.put("rng", "text/plain");
        m.put("pm", "text/x-perl");
        m.put("etx", "text/x-setext");
        m.put("pp", "text/x-pascal");
        m.put("cpt", "application/mac-compactpro");
        m.put("rnc", "application/relax-ng-compact-syntax");
        m.put("4th", "text/x-forth");
        m.put("ps", "application/postscript");
        m.put("rmp", "audio/x-pn-realaudio-plugin");
        m.put("heif", "image/heif");
        m.put("bash", "application/x-sh");
        m.put("wmls", "text/vnd.wap.wmlscript");
        m.put("rmi", "audio/midi");
        m.put("nef", "image/x-raw-nikon");
        m.put("py", "text/x-python");
        m.put("nes", "application/x-nesrom");
        m.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
        m.put("rms", "application/vnd.jcp.javame.midlet-rms");
        m.put("heic", "image/heic");
        m.put("xyz", "chemical/x-xyz");
        m.put("tsd", "application/timestamped-data");
        m.put("pkg", "application/octet-stream");
        m.put("amr", "audio/amr");
        m.put("e57", "model/e57");
        m.put("cdkey", "application/vnd.mediastation.cdkey");
        m.put("qt", "video/quicktime");
        m.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
        m.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
        m.put("sisx", "application/vnd.symbian.install");
        m.put("trm", "application/x-msterminal");
        m.put("rnx", "text/plain");
        m.put("ami", "application/vnd.amiga.ami");
        m.put("mscml", "application/mediaservercontrol+xml");
        m.put("amf", "application/x-amf");
        m.put("ra", "audio/x-pn-realaudio");
        m.put("rb", "text/x-ruby");
        m.put("crt", "application/x-x509-cert");
        m.put("ttc", "application/x-font-ttf");
        m.put("conf", "text/x-config");
        m.put("adoc.txt", "text/x-asciidoc");
        m.put("rl", "application/resource-lists+xml");
        m.put("rm", "application/vnd.rn-realmedia");
        m.put("plf", "application/vnd.pocketlearn");
        m.put("crw", "image/x-raw-canon");
        m.put("rq", "application/sparql-query");
        m.put("crx", "application/x-chrome-package");
        m.put("application", "application/x-ms-application");
        m.put("plb", "application/vnd.3gpp.pic-bw-large");
        m.put("ttf", "application/x-font-ttf");
        m.put("rs", "application/rls-services+xml");
        m.put("plc", "application/vnd.mobius.plc");
        m.put("crd", "application/x-mscardfile");
        m.put("thmx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        m.put("pki", "application/pkixcmp");
        m.put("minipsf", "audio/x-psf");
        m.put("crl", "application/pkix-crl");
        m.put("sc", "application/vnd.ibm.secure-container");
        m.put("cst", "application/x-director");
        m.put("sh", "application/x-sh");
        m.put("css", "text/css");
        m.put("csp", "application/vnd.commonspace");
        m.put("xbap", "application/x-ms-xbap");
        m.put("jad", "text/vnd.sun.j2me.app-descriptor");
        m.put("so", "application/octet-stream");
        m.put("uris", "text/uri-list");
        m.put("st", "text/x-stsrc");
        m.put("sz", "application/x-snappy-framed");
        m.put("rpm", "application/x-rpm");
        m.put("jb2", "image/x-jbig2");
        m.put("csh", "application/x-csh");
        m.put("pls", "application/pls+xml");
        m.put("apt", "text/plain");
        m.put("acfm", "application/x-font-adobe-metric");
        m.put("apr", "application/vnd.lotus-approach");
        m.put("ext", "application/vnd.novadigm.ext");
        m.put("tk", "text/x-tcl");
        m.put("ez3", "application/vnd.ezpix-package");
        m.put("exr", "image/aces");
        m.put("jpeg", "image/jpeg");
        m.put("tr", "text/troff");
        m.put("project", "text/plain");
        m.put("exe", "application/x-dosexec");
        m.put("sas7bdat", "application/x-sas-data");
        m.put("pml", "application/vnd.ctc-posml");
        m.put("ocaml", "text/x-ocaml");
        m.put("apk", "application/vnd.android.package-archive");
        m.put("ez2", "application/vnd.ezpix-album");
        m.put("exp", "text/x-expect");
        m.put("les", "application/vnd.hhe.lesson-player");
        m.put("jar", "application/java-archive");
        m.put("jam", "application/vnd.jam");
        m.put("haml", "text/x-haml");
        m.put("pod", "text/plain");
        m.put("rsd", "application/rsd+xml");
        m.put("twd", "application/vnd.simtech-mindmapper");
        m.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        m.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        m.put("uu", "text/x-uuencode");
        m.put("pnm", "image/x-portable-anymap");
        m.put("jpgv", "video/jpeg");
        m.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        m.put("vb", "text/x-vbdotnet");
        m.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        m.put("vf", "application/x-tex-virtual-font");
        m.put("rtf", "application/rtf");
        m.put("c4u", "application/vnd.clonk.c4group");
        m.put("ppd", "application/vnd.cups-ppd");
        m.put("jpgm", "image/jpm");
        m.put("lha", "application/octet-stream");
        m.put("txf", "application/vnd.mobius.txf");
        m.put("txd", "application/vnd.genomatix.tuxedo");
        m.put("dwfx", "model/vnd.dwfx+xps");
        m.put("ppa", "application/vnd.ms-powerpoint");
        m.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
        m.put("vm", "text/plain");
        m.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        m.put("c4p", "application/vnd.clonk.c4group");
        m.put("jdf", "application/x-jeol-jdf");
        m.put("ppm", "image/x-portable-pixmap");
        m.put("ppj", "image/vnd.adobe.premiere");
        m.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
        m.put("arw", "image/x-raw-sony");
        m.put("c4f", "application/vnd.clonk.c4group");
        m.put("pot", "application/vnd.ms-powerpoint");
        m.put("hprof.txt", "application/vnd.java.hprof.text");
        m.put("rss", "application/rss+xml");
        m.put("arc", "application/x-internet-archive");
        m.put("lisp", "text/x-common-lisp");
        m.put("c4d", "application/vnd.clonk.c4group");
        m.put("rst", "text/x-rst");
        m.put("list", "text/plain");
        m.put("pom", "text/plain");
        m.put("arj", "application/x-arj");
        m.put("c4g", "application/vnd.clonk.c4group");
        m.put("vsdx", "application/vnd.ms-visio.drawing");
        m.put("sv4crc", "application/x-sv4crc");
        m.put("wl", "application/vnd.wolfram.wl");
        m.put("cww", "application/prs.cww");
        m.put("r3d", "image/x-raw-red");
        m.put("pqa", "application/vnd.palm");
        m.put("wm", "video/x-ms-wm");
        m.put("asp", "text/asp");
        m.put("wp", "application/vnd.wordperfect");
        m.put("nml", "application/vnd.enliven");
        m.put("rw2", "image/x-raw-panasonic");
        m.put("vsdm", "application/vnd.ms-visio.drawing.macroenabled.12");
        m.put("asx", "application/x-ms-asx");
        m.put("ppt", "application/vnd.ms-powerpoint");
        m.put("asf", "video/x-ms-asf");
        m.put("idml", "application/vnd.adobe.indesign-idml-package");
        m.put("pps", "application/vnd.ms-powerpoint");
        m.put("asc", "application/pgp-signature");
        m.put("minipsf1", "audio/x-psf");
        m.put("onetmp", "application/onenote");
        m.put("aso", "application/vnd.accpac.simply.aso");
        m.put("ppz", "application/vnd.ms-powerpoint");
        m.put("asm", "text/x-assembly");
        m.put("rtx", "text/richtext");
        m.put("nlu", "application/vnd.neurolanguage.nlu");
        m.put("cwk", "application/x-appleworks");
        m.put("lhs", "text/x-haskell");
        m.put("prf", "application/pics-rules");
        m.put("nnd", "application/vnd.noblenet-directory");
        m.put("atx", "application/vnd.antix.game-component");
        m.put("hpgl", "application/vnd.hp-hpgl");
        m.put("pre", "application/vnd.lotus-freelance");
        m.put("cxx", "text/x-c++src");
        m.put("xo", "application/vnd.olpc-sugar");
        m.put("prc", "application/x-mobipocket-ebook");
        m.put("cxt", "application/x-director");
        m.put("xq", "application/xquery");
        m.put("jfi", "image/jpeg");
        m.put("pro", "text/x-prolog");
        m.put("ibooks", "application/x-ibooks+zip");
        m.put("sas7bbak", "application/x-sas-backup");
        m.put("jisp", "application/vnd.jisp");
        m.put("xz", "application/x-xz");
        m.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        m.put("atc", "application/vnd.acucorp");
        m.put("p12", "application/x-pkcs12");
        m.put("p10", "application/pkcs10");
        m.put("latex", "application/x-latex");
        m.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        m.put("oprc", "application/vnd.palm");
        m.put("schemas", "text/plain");
        m.put("psf", "application/x-font-linux-psf");
        m.put("psd", "image/vnd.adobe.photoshop");
        m.put("psb", "application/vnd.3gpp.pic-bw-small");
        m.put("xweb", "text/plain");
        m.put("wb3", "application/x-quattro-pro");
        m.put("wb1", "application/x-quattro-pro");
        m.put("wb2", "application/x-quattro-pro");
        m.put("7z", "application/x-7z-compressed");
        m.put("opus", "audio/opus");
        m.put("prt", "application/x-prt");
        m.put("tzx", "application/x-spectrum-tzx");
        m.put("nns", "application/vnd.noblenet-sealer");
        m.put("emlx", "message/x-emlx");
        m.put("onetoc", "application/onenote; format=onetoc2");
        m.put("emma", "application/emma+xml");
        m.put("xfdf", "application/vnd.adobe.xfdf");
        m.put("nnw", "application/vnd.noblenet-web");
        m.put("xfdl", "application/vnd.xfdl");
        m.put("pict", "image/x-pict");
        m.put("dfac", "application/vnd.dreamfactory");
        m.put("hpid", "application/vnd.hp-hpid");
        m.put("wav", "audio/vnd.wave");
        m.put("hdf", "application/x-hdf");
        m.put("war", "application/x-tika-java-web-archive");
        m.put("avi", "video/x-msvideo");
        m.put("rwz", "image/x-raw-rawzor");
        m.put("pst", "application/vnd.ms-outlook-pst");
        m.put("avif", "image/avif");
        m.put("mjp2", "video/mj2");
        m.put("wad", "application/x-doom");
        m.put("he5", "application/x-hdf");
        m.put("mpg4", "video/mp4");
        m.put("mpeg", "video/mpeg");
        m.put("wbs", "application/vnd.criticaltools.wbs+xml");
        m.put("jif", "image/jpeg");
        m.put("ptx", "image/x-raw-pentax");
        m.put("awk", "text/x-awk");
        m.put("wax", "audio/x-ms-wax");
        m.put("pub", "application/x-mspublisher");
        m.put("efif", "application/vnd.picsel");
        m.put("hdr", "application/envi.hdr");
        m.put("npx", "image/vnd.net-fpx");
        m.put("markdown", "text/x-web-markdown");
        m.put("fb2", "application/x-fictionbook+xml");
        m.put("asnd", "audio/vnd.adobe.soundbooth");
        m.put("chrt", "application/vnd.kde.kchart");
        m.put("hfa", "application/x-erdas-hfa");
        m.put("zirz", "application/vnd.zul");
        m.put("wcm", "application/vnd.ms-works");
        m.put("axx", "application/x-axcrypt");
        m.put("warc.gz", "application/warc+gz");
        m.put("vrml", "model/vrml");
        m.put("pvb", "application/vnd.3gpp.pic-bw-var");
        m.put("psf1", "audio/x-psf");
        m.put("log", "text/x-log");
        m.put("nsf", "application/vnd.lotus-notes");
        m.put("manifest", "text/plain");
        m.put("azf", "application/vnd.airzip.filesecure.azf");
        m.put("pwn", "application/vnd.3m.post-it-notes");
        m.put("xenc", "application/xenc+xml");
        m.put("mpga", "audio/mpeg");
        m.put("wdb", "application/vnd.ms-works");
        m.put("ihtml", "text/plain");
        m.put("nrw", "image/x-raw-nikon");
        m.put("php3", "text/x-php");
        m.put("php4", "text/x-php");
        m.put("dita", "application/dita+xml; format=topic");
        m.put("uoml", "application/vnd.uoml+xml");
        m.put("xgrm", "text/plain");
        m.put("ditamap", "application/dita+xml; format=map");
        m.put("aspx", "text/aspdotnet");
        m.put("fbs", "image/vnd.fastbidsheet");
        m.put("uc2", "application/x-uc2-compressed");
        m.put("dist", "application/octet-stream");
        m.put("wbmp", "image/vnd.wap.wbmp");
        m.put("ntf", "image/nitf");
        m.put("azw", "application/vnd.amazon.ebook");
        m.put("oxps", "application/vnd.ms-xpsdocument");
        m.put("fdf", "application/vnd.fdf");
        m.put("xquery", "application/xquery");
        m.put("pxn", "image/x-raw-logitech");
        m.put("jks", "application/x-java-keystore");
        m.put("bibtex", "application/x-bibtex-text-file");
        m.put("azs", "application/vnd.airzip.filesecure.azs");
        m.put("fcs", "application/vnd.isac.fcs");
        m.put("wmlsc", "application/vnd.wap.wmlscriptc");
        m.put("p7s", "application/pkcs7-signature");
        m.put("cdxml", "application/vnd.chemdraw+xml");
        m.put("texinfo", "application/x-texinfo");
        m.put("pyv", "video/vnd.ms-playready.media.pyv");
        m.put("p7r", "application/x-pkcs7-certreqresp");
        m.put("xvml", "application/xv+xml");
        m.put("tcsh", "application/x-csh");
        m.put("daf", "application/vnd.mobius.daf");
        m.put("p7m", "application/pkcs7-mime");
        m.put("jlt", "application/vnd.hp-jlyt");
        m.put("smil", "application/smil+xml");
        m.put("p7c", "application/pkcs7-mime");
        m.put("p7b", "application/x-pkcs7-certificates");
        m.put("pya", "audio/vnd.ms-playready.media.pya");
        m.put("xargs", "text/plain");
        m.put("sldasm", "application/sldworks");
        m.put("xslfo", "application/xslfo+xml");
        m.put("jng", "video/x-jng");
        m.put("lrf", "application/octet-stream");
        m.put("jp2", "image/jp2");
        m.put("btif", "image/prs.btif");
        m.put("dbf", "application/x-dbf");
        m.put("sa7", "application/x-sas-access");
        m.put("fff", "image/x-raw-imacon");
        m.put("lrm", "application/vnd.ms-lrm");
        m.put("fg5", "application/vnd.fujitsu.oasysgp");
        m.put("jmx", "text/plain");
        m.put("scurl", "text/vnd.curl.scurl");
        m.put("fgd", "application/x-director");
        m.put("xport", "application/x-sas-xport");
        m.put("cfml", "text/x-coldfusion");
        m.put("pkipath", "application/pkix-pkipath");
        m.put("dcl", "text/plain");
        m.put("CBL", "text/x-cobol");
        m.put("h++", "text/x-c++hdr");
        m.put("lsp", "text/x-common-lisp");
        m.put("adoc", "text/x-asciidoc");
        m.put("fh7", "image/x-freehand");
        m.put("dd2", "application/vnd.oma.dd2+xml");
        m.put("fh4", "image/x-freehand");
        m.put("fh5", "image/x-freehand");
        m.put("fh8", "image/x-freehand");
        m.put("fh9", "image/x-freehand");
        m.put("ddd", "application/vnd.fujixerox.ddd");
        m.put("sas", "application/x-sas");
        m.put("sap", "audio/x-sap");
        m.put("wk4", "application/vnd.lotus-1-2-3");
        m.put("jpf", "image/jpx");
        m.put("fhc", "image/x-freehand");
        m.put("text", "text/plain");
        m.put("ltf", "application/vnd.frogans.ltf");
        m.put("wk2", "application/vnd.lotus-1-2-3");
        m.put("wk3", "application/vnd.lotus-1-2-3");
        m.put("jpe", "image/jpeg");
        m.put("sldprt", "application/sldworks");
        m.put("hlp", "application/winhlp");
        m.put("sav", "application/x-spss-sav");
        m.put("texi", "application/x-texinfo");
        m.put("sc7", "application/x-sas-catalog");
        m.put("jpm", "image/jpm");
        m.put("rpst", "application/vnd.nokia.radio-preset");
        m.put("dcs", "image/x-raw-kodak");
        m.put("rpss", "application/vnd.nokia.radio-presets");
        m.put("dcr", "application/x-director");
        m.put("wk1", "application/vnd.lotus-1-2-3");
        m.put("saf", "application/vnd.yamaha.smaf-audio");
        m.put("yml", "text/x-yaml");
        m.put("dcx", "image/vnd.zbrush.dcx");
        m.put("fig", "application/x-xfig");
        m.put("3ds", "image/x-3ds");
        m.put("def", "text/plain");
        m.put("deb", "application/x-debian-package");
        m.put("sd2", "application/x-sas-data-v6");
        m.put("cbor", "application/cbor");
        m.put("fits", "application/fits");
        m.put("sas7butl", "application/x-sas-utility");
        m.put("sas7bmdb", "application/x-sas-mddb");
        m.put("junit", "text/plain");
        m.put("dcurl", "text/vnd.curl.dcurl");
        m.put("sd7", "application/x-sas-data");
        m.put("ufd", "application/vnd.ufdl");
        m.put("Bas", "text/x-basic");
        m.put("xlex", "text/plain");
        m.put("scad", "application/x-openscad");
        m.put("lua", "text/x-lua");
        m.put("seed", "application/vnd.fdsn.seed");
        m.put("scs", "application/scvp-cv-response");
        m.put("scq", "application/scvp-cv-request");
        m.put("3g2", "video/3gpp2");
        m.put("wks", "application/vnd.ms-works");
        m.put("cmdf", "chemical/x-cmdf");
        m.put("lvp", "audio/vnd.lucent.voice");
        m.put("scd", "application/x-msschedule");
        m.put("bas", "text/x-basic");
        m.put("bat", "application/x-bat");
        m.put("fit", "application/fits");
        m.put("der", "application/x-x509-cert; format=der");
        m.put("MYI", "application/x-mysql-misam-compressed-index");
        m.put("wkq", "application/x-quattro-pro");
        m.put("silo", "model/mesh");
        m.put("scm", "text/x-scheme");
        m.put("bay", "image/x-raw-casio");
        m.put("MYD", "application/x-mysql-misam-data");
        m.put("bau", "application/vnd.openofficeorg.autotext");
        m.put("twds", "application/vnd.simtech-mindmapper");
        m.put("dex", "application/x-dex");
        m.put("sf7", "application/x-sas-fdb");
        m.put("lwp", "application/vnd.lotus-wordpro");
        m.put("wmlc", "application/vnd.wap.wmlc");
        m.put("3fr", "image/x-raw-hasselblad");
        m.put("sdp", "application/sdp");
        m.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
        m.put("wma", "audio/x-ms-wma");
        m.put("dgn", "image/vnd.dgn");
        m.put("xliff", "application/x-xliff+xml");
        m.put("sdw", "application/vnd.stardivision.writer");
        m.put("jsp", "text/x-jsp");
        m.put("sdc", "application/vnd.stardivision.calc");
        m.put("sdd", "application/vnd.stardivision.impress");
        m.put("sda", "application/vnd.stardivision.draw");
        m.put("vhdl", "text/x-vhdl");
        m.put("bdf", "application/x-font-bdf");
        m.put("wmz", "application/x-ms-wmz");
        m.put("wmx", "video/x-ms-wmx");
        m.put("fli", "video/x-fli");
        m.put("ser", "application/java-serialized-object");
        m.put("numbers", "application/vnd.apple.numbers");
        m.put("wmv", "video/x-ms-wmv");
        m.put("xconf", "text/x-config");
        m.put("hps", "application/vnd.hp-hps");
        m.put("bdm", "application/vnd.syncml.dm+wbxml");
        m.put("hpp", "text/x-c++hdr");
        m.put("flo", "application/vnd.micrografx.flo");
        m.put("lz4", "application/x-lz4");
        m.put("sed", "text/x-sed");
        m.put("see", "application/vnd.seemail");
        m.put("wmf", "image/wmf");
        m.put("wmd", "application/x-ms-wmd");
        m.put("qam", "application/vnd.epson.quickanime");
        m.put("flc", "video/x-flc");
        m.put("svgz", "image/svg+xml");
        m.put("j2c", "image/x-jp2-codestream");
        m.put("3gp", "video/3gpp");
        m.put("xhvml", "application/xv+xml");
        m.put("wml", "text/vnd.wap.wml");
        m.put("lyr", "application/x-esri-layer");
        m.put("PAS", "text/x-pascal");
        m.put("sfs", "application/vnd.spotfire.sfs");
        m.put("dif", "application/dif+xml");
        m.put("qbo", "application/vnd.intu.qbo");
        m.put("meta", "text/plain");
        m.put("dir", "application/x-director");
        m.put("csml", "chemical/x-csml");
        m.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
        m.put("psflib", "audio/x-psf");
        m.put("karbon", "application/vnd.kde.karbon");
        m.put("flx", "text/vnd.fmi.flexstor");
        m.put("fly", "text/vnd.fly");
        m.put("amfm", "application/x-font-adobe-metric");
        m.put("flv", "video/x-flv");
        m.put("flw", "application/vnd.kde.kivio");
        m.put("wp5", "application/vnd.wordperfect");
        m.put("wp6", "application/vnd.wordperfect");
        m.put("asice", "application/vnd.etsi.asic-e+zip");
        m.put("mesh", "model/mesh");
        m.put("oa2", "application/vnd.fujitsu.oasys2");
        m.put("oa3", "application/vnd.fujitsu.oasys3");
        m.put("si7", "application/x-sas-data-index");
        m.put("bh2", "application/vnd.fujitsu.oasysprs");
        m.put("fp7", "application/x-filemaker");
        m.put("wpd", "application/vnd.wordperfect");
        m.put("asics", "application/vnd.etsi.asic-s+zip");
        m.put("dis", "application/vnd.mobius.dis");
        m.put("hqx", "application/mac-binhex40");
        m.put("lzh", "application/octet-stream");
        m.put("fnc", "application/vnd.frogans.fnc");
        m.put("sgl", "application/vnd.stardivision.writer-global");
        m.put("wq2", "application/x-quattro-pro");
        m.put("sgm", "text/sgml");
        m.put("wq1", "application/x-quattro-pro");
        m.put("setreg", "application/set-registration-initiation");
        m.put("shw", "application/x-corelpresentations");
        m.put("sib", "application/x-sibelius");
        m.put("wqd", "application/vnd.wqd");
        m.put("for", "text/x-fortran");
        m.put("wpl", "application/vnd.ms-wpl");
        m.put("djv", "image/vnd.djvu");
        m.put("setpay", "application/set-payment-initiation");
        m.put("shf", "application/shf+xml");
        m.put("C", "text/x-c++src");
        m.put("mpkg", "application/vnd.apple.installer+xml");
        m.put("F", "text/x-fortran");
        m.put("wps", "application/vnd.ms-works");
        m.put("H", "text/x-c++hdr");
        m.put("wpt", "application/vnd.wordperfect");
        m.put("shp", "application/x-shapefile");
        m.put("-gz", "application/gzip");
        m.put("dll", "application/x-msdownload");
        m.put("coffee", "text/x-coffeescript");
        m.put("mdtext", "text/x-web-markdown");
        m.put("oas", "application/vnd.fujitsu.oasys");
        m.put("S", "text/x-assembly");
        m.put("htm", "text/html");
        m.put("sit", "application/x-stuffit");
        m.put("jxl", "image/jxl");
        m.put("dbase", "application/x-dbf");
        m.put("dgnlib", "image/vnd.dgn");
        m.put("curl", "text/vnd.curl");
        m.put("umj", "application/vnd.umajin");
        m.put("a", "application/x-archive");
        m.put("sig", "application/pgp-signature");
        m.put("c", "text/x-csrc");
        m.put("d", "text/x-d");
        m.put("e", "text/x-eiffel");
        m.put("f", "text/x-fortran");
        m.put("sis", "application/vnd.symbian.install");
        m.put("g", "text/plain");
        m.put("h", "text/x-chdr");
        m.put("ustar", "application/x-ustar");
        m.put("l", "text/x-lex");
        m.put("xhtml", "application/xhtml+xml");
        m.put("htc", "text/plain");
        m.put("m", "text/x-objcsrc");
        m.put("clkk", "application/vnd.crick.clicker.keyboard");
        m.put("sas7bitm", "application/x-sas-itemstor");
        m.put("p", "text/x-pascal");
        m.put("qfx", "application/vnd.intu.qfx");
        m.put("r", "text/x-rsrc");
        m.put("s", "text/x-assembly");
        m.put("dmg", "application/x-apple-diskimage");
        m.put("t", "text/troff");
        m.put("Frm", "text/x-vbasic");
        m.put("skd", "application/vnd.koan");
        m.put("v", "text/x-verilog");
        m.put("CLS", "text/x-vbasic");
        m.put("dms", "application/octet-stream");
        m.put("clkp", "application/vnd.crick.clicker.palette");
        m.put("3mf", "application/vnd.ms-package.3dmanufacturing-3dmodel+xml");
        m.put("y", "text/x-yacc");
        m.put("z", "application/x-compress");
        m.put("bin", "application/octet-stream");
        m.put("dmp", "application/vnd.tcpdump.pcap");
        m.put("obd", "application/x-msbinder");
        m.put("wrl", "model/vrml");
        m.put("wri", "application/x-mswrite");
        m.put("fpx", "image/vnd.fpx");
        m.put("bib", "application/x-bibtex-text-file");
        m.put("sdkm", "application/vnd.solent.sdkm+xml");
        m.put("groovy", "text/x-groovy");
        m.put("wtb", "application/vnd.webturbo");
        m.put("hvs", "application/vnd.yamaha.hv-script");
        m.put("hvp", "application/vnd.yamaha.hv-voice");
        m.put("udeb", "application/x-debian-package");
        m.put("frm", "text/x-vbasic");
        m.put("sdkd", "application/vnd.solent.sdkm+xml");
        m.put("oda", "application/oda");
        m.put("odb", "application/vnd.oasis.opendocument.base");
        m.put("ft8", "image/x-freehand");
        m.put("ft9", "image/x-freehand");
        m.put("ft7", "image/x-freehand");
        m.put("sas7bacs", "application/x-sas-access");
        m.put("xegrm", "text/plain");
        m.put("chat", "application/x-chat");
        m.put("skm", "application/vnd.koan");
        m.put("skt", "application/vnd.koan");
        m.put("sm7", "application/x-sas-mddb");
        m.put("dng", "image/x-raw-adobe");
        m.put("skp", "application/vnd.koan");
        m.put("hwpx", "application/hwp+zip");
        m.put("wp61", "application/vnd.wordperfect");
        m.put("hvd", "application/vnd.yamaha.hv-dic");
        m.put("jfif", "image/jpeg");
        m.put("dna", "application/vnd.dna");
        m.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        m.put("odt", "application/vnd.oasis.opendocument.text");
        m.put("MF", "text/plain");
        m.put("smf", "application/vnd.stardivision.math");
        m.put("w3d", "application/x-director");
        m.put("dot", "application/msword");
        m.put("fst", "image/vnd.fst");
        m.put("odi", "application/vnd.oasis.opendocument.image");
        m.put("odg", "application/vnd.oasis.opendocument.graphics");
        m.put("odf", "application/vnd.oasis.opendocument.formula");
        m.put("odc", "application/vnd.oasis.opendocument.chart");
        m.put("slt", "application/vnd.epson.salt");
        m.put("odp", "application/vnd.oasis.opendocument.presentation");
        m.put("doc", "application/msword");
        m.put("fsc", "application/vnd.fsc.weblaunch");
        m.put("fts", "application/fits");
        m.put("mat", "application/x-matlab-data");
        m.put("dpx", "image/x-dpx");
        m.put("uri", "text/uri-list");
        m.put("mmpt", "application/vnd.mindjet.mindmanager");
        m.put("snf", "application/x-font-snf");
        m.put("hxx", "text/x-c++hdr");
        m.put("snd", "audio/basic");
        m.put("dpr", "text/x-pascal");
        m.put("ftc", "application/vnd.fluxtime.clip");
        m.put("sml", "application/smil+xml");
        m.put("clkx", "application/vnd.crick.clicker");
        m.put("mag", "application/vnd.ecowin.chart");
        m.put("atomsvc", "application/atomsvc+xml");
        m.put("clkw", "application/vnd.crick.clicker.wordbank");
        m.put("clkt", "application/vnd.crick.clicker.template");
        m.put("smi", "application/smil+xml");
        m.put("man", "text/troff");
        m.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
        m.put("dpg", "application/vnd.dpgraph");
        m.put("mc1", "application/vnd.medcalcdata");
        m.put("COB", "text/x-cobol");
        m.put("CPP", "text/x-c++src");
        m.put("bmi", "application/vnd.bmi");
        m.put("dtshd", "audio/vnd.dts.hd");
        m.put("oga", "audio/ogg");
        m.put("w60", "application/vnd.wordperfect");
        m.put("sp7", "application/x-sas-putility");
        m.put("wvx", "video/x-ms-wvx");
        m.put("mbk", "application/vnd.mobius.mbk");
        m.put("fvt", "video/vnd.fvt");
        m.put("book", "application/vnd.framemaker");
        m.put("perl", "text/x-perl");
        m.put("ogx", "application/ogg");
        m.put("portpkg", "application/vnd.macports.portpkg");
        m.put("mdb", "application/x-msaccess");
        m.put("f4v", "video/x-f4v");
        m.put("spf", "application/vnd.yamaha.smaf-phrase");
        m.put("spc", "application/x-pkcs7-certificates");
        m.put("u32", "application/x-authorware-bin");
        m.put("drc", "video/x-dirac");
        m.put("ogm", "video/x-ogm");
        m.put("tcap", "application/vnd.3gpp2.tcap");
        m.put("fh50", "image/x-freehand");
        m.put("hbci", "application/vnd.hbci");
        m.put("mcd", "application/vnd.mcd");
        m.put("ogg", "audio/vorbis");
        m.put("ufdl", "application/vnd.ufdl");
        m.put("anpa", "text/vnd.iptc.anpa");
        m.put("drf", "image/x-raw-kodak");
        m.put("dsp", "text/plain");
        m.put("pclxl", "application/vnd.hp-pclxl");
        m.put("boz", "application/x-bzip2");
        m.put("mmmp", "application/vnd.mindjet.mindmanager");
        m.put("box", "application/vnd.previewsystems.box");
        m.put("gslib", "audio/x-psf");
        m.put("dsw", "text/plain");
        m.put("f77", "text/x-fortran");
        m.put("spq", "application/scvp-vp-request");
        m.put("acutc", "application/vnd.acucorp");
        m.put("dsc", "text/prs.lines.tag");
        m.put("listafp", "application/vnd.ibm.modcap");
        m.put("mdi", "image/vnd.ms-modi");
        m.put("spp", "application/scvp-vp-response");
        m.put("sr2", "image/x-raw-sony");
        m.put("spl", "application/x-futuresplash");
        m.put("dbase3", "application/x-dbf");
        m.put("utz", "application/vnd.uiq.theme");
        m.put("spx", "audio/speex");
        m.put("sr7", "application/x-sas-itemstor");
        m.put("mdo", "text/plain");
        m.put("src", "application/x-wais-source");
        m.put("dts", "audio/vnd.dts");
        m.put("bpm", "application/bizagi-modeler");
        m.put("srl", "application/sereal");
        m.put("srf", "image/x-raw-sony");
        m.put("dtd", "application/xml-dtd");
        m.put("dtb", "application/x-dtbook+xml");
        m.put("midi", "audio/midi");
        m.put("dta", "application/x-stata-dta");
        m.put("sas7bpgm", "application/x-sas-program-data");
        m.put("mef", "image/x-raw-mamiya");
        m.put("sql", "text/x-sql");
        m.put("kar", "audio/midi");
        m.put("bpk", "application/octet-stream");
        m.put("fodp", "application/vnd.oasis.opendocument.flat.presentation");
        m.put("bpg", "image/x-bpg");
        m.put("fods", "application/vnd.oasis.opendocument.flat.spreadsheet");
        m.put("fodt", "application/vnd.oasis.opendocument.flat.text");
        m.put("ss7", "application/x-sas-program-data");
        m.put("sse", "application/vnd.kodak-descriptor");
        m.put("mxml", "application/xv+xml");
        m.put("sas7bvew", "application/x-sas-view");
        m.put("unityweb", "application/vnd.unity");
        m.put("joda", "application/vnd.joost.joda-archive");
        m.put("cwiki", "text/plain");
        m.put("ssf", "application/vnd.epson.ssf");
        m.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        m.put("mfm", "application/vnd.mfmp");
        m.put("epub", "application/epub+zip");
        m.put("srt", "application/x-subrip");
        m.put("f90", "text/x-fortran");
        m.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        m.put("rexx", "text/x-rexx");
        m.put("srx", "application/sparql-results+xml");
        m.put("st7", "application/x-sas-audit");
        m.put("stf", "application/vnd.wt.stf");
        m.put("stc", "application/vnd.sun.xml.calc.template");
        m.put("std", "application/vnd.sun.xml.draw.template");
        m.put("mgz", "application/vnd.proteus.magazine");
        m.put("memgraph", "application/x-memgraph");
        m.put("fzs", "application/vnd.fuzzysheet");
        m.put("stk", "application/hyperstudio");
        m.put("indd", "application/x-adobe-indesign");
        m.put("kdc", "image/x-raw-kodak");
        m.put("stl", "model/x.stl-binary");
        m.put("sti", "application/vnd.sun.xml.impress.template");
        m.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        m.put("su7", "application/x-sas-utility");
        m.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        m.put("brotli", "application/x-brotli");
        m.put("icns", "image/icns");
        m.put("dvi", "application/x-dvi");
        m.put("restx", "text/x-rst");
        m.put("mif", "application/vnd.mif");
        m.put("wsdd", "text/plain");
        m.put("mid", "audio/midi");
        m.put("xcat", "text/plain");
        m.put("qps", "application/vnd.pg.format");
        m.put("sv7", "application/x-sas-view");
        m.put("dwg", "image/vnd.dwg");
        m.put("123", "application/vnd.lotus-1-2-3");
        m.put("mj2", "video/mj2");
        m.put("deploy", "application/octet-stream");
        m.put("wsdl", "application/wsdl+xml");
        m.put("teacher", "application/vnd.smart.teacher");
        m.put("zaz", "application/vnd.zzazz.deck+xml");
        m.put("dwf", "model/vnd.dwf");
        m.put("str", "application/vnd.pg.format");
        m.put("qpw", "application/x-quattro-pro");
        m.put("mht", "multipart/related");
        m.put("list3820", "application/vnd.ibm.modcap");
        m.put("stw", "application/vnd.sun.xml.writer.template");
        m.put("stx", "application/x-sas-transport");
        m.put("bsh", "text/plain");
        m.put("svd", "application/vnd.svd");
        m.put("dxr", "application/x-director");
        m.put("key", "application/vnd.apple.keynote");
        m.put("ngdat", "application/vnd.nokia.n-gage.data");
        m.put("one", "application/onenote; format=one");
        m.put("movie", "video/x-sgi-movie");
        m.put("dxf", "image/vnd.dxf");
        m.put("sus", "application/vnd.sus-calendar");
        m.put("sas7bcat", "application/x-sas-catalog");
        m.put("dxb", "image/vnd.dxb");
        m.put("dxp", "application/vnd.spotfire.dxp");
        m.put("swi", "application/vnd.arastra.swi");
        m.put("swf", "application/x-shockwave-flash");
        m.put("mka", "audio/x-matroska");
        m.put("diff", "text/x-diff");
        m.put("ice", "x-conference/x-cooltalk");
        m.put("icb", "image/x-tga");
        m.put("torrent", "application/x-bittorrent");
        m.put("icc", "application/vnd.iccprofile");
        m.put("mkd", "text/x-web-markdown");
        m.put("kfo", "application/vnd.kde.kformula");
        m.put("ssml", "application/ssml+xml");
        m.put("bup", "application/x-dvd-ifo");
        m.put("swa", "application/x-director");
        m.put("sxi", "application/vnd.sun.xml.impress");
        m.put("opf", "application/oebps-package+xml");
        m.put("sxg", "application/vnd.sun.xml.writer.global");
        m.put("webmanifest", "application/manifest+json");
        m.put("sxc", "application/vnd.sun.xml.calc");
        m.put("sxd", "application/vnd.sun.xml.draw");
        m.put("mli", "text/x-ocaml");
        m.put("sxm", "application/vnd.sun.xml.math");
        m.put("toast", "application/x-roxio-toast");
        m.put("jbig2", "image/x-jbig2");
        m.put("xar", "application/vnd.xara");
        m.put("xap", "application/x-silverlight-app");
        m.put("ad.txt", "text/x-asciidoc");
        m.put("vxml", "application/voicexml+xml");
        m.put("ico", "image/vnd.microsoft.icon");
        m.put("icm", "application/vnd.iccprofile");
        m.put("roles", "text/plain");
        m.put("mkv", "video/x-matroska");
        m.put("ics", "text/calendar");
        m.put("grxml", "application/srgs+xml");
        m.put("3dml", "text/vnd.in3d.3dml");
        m.put("xsamples", "text/plain");
        m.put("rest", "text/x-rst");
        m.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
        m.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
        m.put("kia", "application/vnd.kidspiration");
        m.put("xbm", "image/x-xbitmap");
        m.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
        m.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        m.put("ief", "image/ief");
        m.put("gac", "application/vnd.groove-account");
        m.put("s7m", "application/x-sas-dmdb");
        m.put("mmf", "application/vnd.smaf");
        m.put("sxw", "application/vnd.sun.xml.writer");
        m.put("susp", "application/vnd.sus-calendar");
        m.put("mlp", "application/vnd.dolby.mlp");
        m.put("idl", "text/x-idl");
        m.put("epsi", "application/postscript");
        m.put("mime", "message/rfc822");
        m.put("xbd", "application/vnd.fujixerox.docuworks.binder");
        m.put("epsf", "application/postscript");
        m.put("org", "application/vnd.lotus-organizer");
        m.put("sbml", "application/sbml+xml");
        m.put("ifb", "text/calendar");
        m.put("orf", "image/x-raw-olympus");
        m.put("wspolicy", "application/wspolicy+xml");
        m.put("mng", "video/x-mng");
        m.put("mmr", "image/vnd.fujixerox.edmics-mmr");
        m.put("ttml", "application/ttml+xml");
        m.put("mmp", "application/vnd.mindjet.mindmanager");
        m.put("kil", "application/x-killustrator");
        m.put("pcurl", "application/vnd.curl.pcurl");
        m.put("bz2", "application/x-bzip2");
        m.put("xcf", "image/x-xcf");
        EXT_TO_MIME_TYPE = Collections.unmodifiableMap(m);
        HashMap<String, String> extToMimeType = new HashMap<String, String>();
        for (Map.Entry<String, String> stringStringEntry : EXT_TO_MIME_TYPE.entrySet()) {
            extToMimeType.putIfAbsent(stringStringEntry.getValue(), stringStringEntry.getKey());
        }
        MIME_TYPE_TO_EXT = Collections.unmodifiableMap(extToMimeType);
    }
}

