/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.detect;

import io.qameta.allure.detect.Clause;

final class MagicMatchClause
implements Clause {
    private final byte[] pattern;
    private final byte[] mask;
    private final int start;
    private final int end;

    MagicMatchClause(byte[] pattern, byte[] mask, int start, int end) {
        this.pattern = pattern;
        this.mask = mask;
        this.start = start;
        this.end = end;
    }

    @Override
    public boolean eval(byte[] data) {
        if (data.length < this.pattern.length + this.start) {
            return false;
        }
        int effectiveEnd = this.end;
        int maxStart = data.length - this.pattern.length;
        if (effectiveEnd > maxStart) {
            effectiveEnd = maxStart;
        }
        if (effectiveEnd < this.start) {
            return false;
        }
        for (int i = this.start; i <= effectiveEnd; ++i) {
            boolean match = true;
            for (int j = 0; match && j < this.pattern.length; ++j) {
                int masked = data[i + j] & 0xFF & (this.mask[j] & 0xFF);
                match = masked == (this.pattern[j] & 0xFF);
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

