/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.detect;

import io.qameta.allure.detect.AndClause;
import io.qameta.allure.detect.Clause;
import io.qameta.allure.detect.Magic;
import io.qameta.allure.detect.MagicMatchClause;
import io.qameta.allure.detect.OrClause;
import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class MagicBytesContentTypeDetector {
    private static final List<Magic> MAGICS;

    private MagicBytesContentTypeDetector() {
        throw new IllegalStateException("Utility class");
    }

    private static byte[] decodeString(String value, String type) {
        byte[] bytes;
        if (value.startsWith("0x")) {
            byte[] vals = new byte[(value.length() - 2) / 2];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = (byte)Integer.parseInt(value.substring(2 + i * 2, 4 + i * 2), 16);
            }
            return vals;
        }
        CharArrayWriter decoded = new CharArrayWriter();
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) == '\\') {
                int j;
                if (value.charAt(i + 1) == '\\') {
                    decoded.write(92);
                    ++i;
                    continue;
                }
                if (value.charAt(i + 1) == 'x') {
                    decoded.write(Integer.parseInt(value.substring(i + 2, i + 4), 16));
                    i += 3;
                    continue;
                }
                if (value.charAt(i + 1) == 'r') {
                    decoded.write(13);
                    ++i;
                    continue;
                }
                if (value.charAt(i + 1) == 'n') {
                    decoded.write(10);
                    ++i;
                    continue;
                }
                for (j = i + 1; j < i + 4 && j < value.length() && Character.isDigit(value.charAt(j)); ++j) {
                }
                decoded.write(Short.decode("0" + value.substring(i + 1, j)).byteValue());
                i = j - 1;
                continue;
            }
            decoded.write(value.charAt(i));
        }
        char[] chars = decoded.toCharArray();
        if ("unicodeLE".equals(type)) {
            bytes = new byte[chars.length * 2];
            for (int i = 0; i < chars.length; ++i) {
                bytes[i * 2] = (byte)(chars[i] & 0xFF);
                bytes[i * 2 + 1] = (byte)(chars[i] >> 8);
            }
        } else if ("unicodeBE".equals(type)) {
            bytes = new byte[chars.length * 2];
            for (int i = 0; i < chars.length; ++i) {
                bytes[i * 2] = (byte)(chars[i] >> 8);
                bytes[i * 2 + 1] = (byte)(chars[i] & 0xFF);
            }
        } else {
            bytes = new byte[chars.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)chars[i];
            }
        }
        return bytes;
    }

    private static Clause createMagicMatch(String value, String mask, String offset, String type) {
        byte[] decodedValue = MagicBytesContentTypeDetector.decodeString(value, type);
        byte[] decodedMask = mask != null ? MagicBytesContentTypeDetector.decodeString(mask, type) : null;
        int patternLength = decodedValue.length;
        if (decodedMask != null && decodedMask.length > patternLength) {
            patternLength = decodedMask.length;
        }
        byte[] resPattern = new byte[patternLength];
        byte[] resMask = new byte[patternLength];
        for (int i = 0; i < patternLength; ++i) {
            resMask[i] = decodedMask != null && i < decodedMask.length ? decodedMask[i] : -1;
            if (i < decodedValue.length) {
                int v = decodedValue[i] & 0xFF;
                int m = resMask[i] & 0xFF;
                resPattern[i] = (byte)(v & m);
                continue;
            }
            resPattern[i] = 0;
        }
        int start = 0;
        int end = 0;
        if (offset != null && !offset.isEmpty()) {
            int colonIdx = offset.indexOf(58);
            if (colonIdx > 0) {
                String startRaw = offset.substring(0, colonIdx);
                String endRaw = offset.substring(colonIdx + 1);
                start = Integer.parseInt(startRaw);
                end = Integer.parseInt(endRaw);
            } else {
                end = start = Integer.parseInt(offset);
            }
        }
        return new MagicMatchClause(resPattern, resMask, start, end);
    }

    public static String detectContentType(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int currentPriority = -1;
        for (Magic magic : MAGICS) {
            if (currentPriority > 0 && currentPriority > magic.getPriority()) break;
            if (!magic.getClause().eval(buffer)) continue;
            if (currentPriority == magic.getPriority()) {
                result.add(magic.getType());
                continue;
            }
            result.clear();
            result.add(magic.getType());
            currentPriority = magic.getPriority();
        }
        if (!result.isEmpty()) {
            return (String)result.get(0);
        }
        return null;
    }

    static {
        ArrayList<Magic> list = new ArrayList<Magic>();
        list.add(new Magic(60, "video/mp4", MagicBytesContentTypeDetector.createMagicMatch("ftypmp42", null, "4", "string"), ".mp4", ".mp4v", ".mpg4"));
        list.add(new Magic(60, "video/mp4", MagicBytesContentTypeDetector.createMagicMatch("ftypmp41", null, "4", "string"), ".mp4", ".mp4v", ".mpg4"));
        list.add(new Magic(50, "image/svg+xml", new AndClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("<svg", null, "0", "string"), MagicBytesContentTypeDetector.createMagicMatch("http://www.w3.org/2000/svg", null, "5:256", "string"))), ".svg", ".svgz"));
        list.add(new Magic(50, "image/png", MagicBytesContentTypeDetector.createMagicMatch("\\x89PNG\\x0d\\x0a\\x1a\\x0a", null, "0", "string"), ".png"));
        list.add(new Magic(50, "application/x-gtar", MagicBytesContentTypeDetector.createMagicMatch("ustar  \\0", null, "257", "string"), ".gtar"));
        list.add(new Magic(50, "application/pdf", MagicBytesContentTypeDetector.createMagicMatch("\\xef\\xbb\\xbf%PDF-", null, "0", "string"), ".pdf"));
        list.add(new Magic(50, "image/gif", MagicBytesContentTypeDetector.createMagicMatch("GIF89a", null, "0", "string"), ".gif"));
        list.add(new Magic(50, "image/gif", MagicBytesContentTypeDetector.createMagicMatch("GIF87a", null, "0", "string"), ".gif"));
        list.add(new Magic(50, "image/bmp", new AndClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("BM", null, "0", "string"), new AndClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("0x0100", null, "26", "string"), new OrClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("0x0000", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x0100", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x0400", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x0800", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x1000", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x1800", null, "28", "string"), MagicBytesContentTypeDetector.createMagicMatch("0x2000", null, "28", "string"))))))), ".bmp", ".dib"));
        list.add(new Magic(50, "application/pdf", MagicBytesContentTypeDetector.createMagicMatch("%PDF-", null, "0", "string"), ".pdf"));
        list.add(new Magic(50, "image/tiff", MagicBytesContentTypeDetector.createMagicMatch("MM\\x00\\x2b", null, "0", "string"), ".tiff", ".tif"));
        list.add(new Magic(50, "image/tiff", MagicBytesContentTypeDetector.createMagicMatch("MM\\x00\\x2a", null, "0", "string"), ".tiff", ".tif"));
        list.add(new Magic(50, "image/tiff", MagicBytesContentTypeDetector.createMagicMatch("II\\x2a\\x00", null, "0", "string"), ".tiff", ".tif"));
        list.add(new Magic(50, "application/zip", MagicBytesContentTypeDetector.createMagicMatch("PK\\x07\\x08", null, "0", "string"), ".zip"));
        list.add(new Magic(50, "application/zip", MagicBytesContentTypeDetector.createMagicMatch("PK\\005\\006", null, "0", "string"), ".zip"));
        list.add(new Magic(50, "application/zip", MagicBytesContentTypeDetector.createMagicMatch("PK\\003\\004", null, "0", "string"), ".zip"));
        list.add(new Magic(50, "image/jpeg", MagicBytesContentTypeDetector.createMagicMatch("0xffd8ff", null, "0", "string"), ".jpg", ".jpeg", ".jpe", ".jif", ".jfif", ".jfi"));
        list.add(new Magic(45, "application/gzip", MagicBytesContentTypeDetector.createMagicMatch("\\x1f\\x8b", null, "0", "string"), ".gz", ".tgz", "-gz"));
        list.add(new Magic(45, "application/gzip", MagicBytesContentTypeDetector.createMagicMatch("\\037\\213", null, "0", "string"), ".gz", ".tgz", "-gz"));
        list.add(new Magic(40, "application/pdf", new AndClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("%%", null, "0:128", "string"), MagicBytesContentTypeDetector.createMagicMatch("%PDF-2.", null, "1:512", "string"))), ".pdf"));
        list.add(new Magic(40, "application/pdf", new AndClause(Arrays.asList(MagicBytesContentTypeDetector.createMagicMatch("%%", null, "0:128", "string"), MagicBytesContentTypeDetector.createMagicMatch("%PDF-1.", null, "1:512", "string"))), ".pdf"));
        list.add(new Magic(40, "application/x-tar", MagicBytesContentTypeDetector.createMagicMatch("ustar\\0", null, "257", "string"), ".tar"));
        list.add(new Magic(20, "application/pdf", MagicBytesContentTypeDetector.createMagicMatch("%PDF-2.", null, "1:512", "string"), ".pdf"));
        list.add(new Magic(20, "application/pdf", MagicBytesContentTypeDetector.createMagicMatch("%PDF-1.", null, "1:512", "string"), ".pdf"));
        MAGICS = list;
    }
}

