/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.retry;

import io.qameta.allure.entity.TestResult;
import io.qameta.allure.metric.Metric;
import io.qameta.allure.metric.MetricLine;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;

public class RetryMetric
implements Metric {
    private final AtomicLong retriesCount = new AtomicLong();
    private final AtomicLong runCount = new AtomicLong();
    private final BiFunction<String, Long, MetricLine> lineFactory;

    public RetryMetric(BiFunction<String, Long, MetricLine> lineFactory) {
        this.lineFactory = lineFactory;
    }

    public void update(TestResult testResult) {
        if (testResult.isRetry()) {
            this.retriesCount.incrementAndGet();
        } else {
            this.runCount.incrementAndGet();
        }
    }

    public List<MetricLine> getLines() {
        return Arrays.asList(this.lineFactory.apply("retries", this.retriesCount.longValue()), this.lineFactory.apply("run", this.runCount.longValue()));
    }
}

