/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.ga;

import com.fasterxml.jackson.databind.json.JsonMapper;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.executor.ExecutorPlugin;
import io.qameta.allure.ga.GaEvent;
import io.qameta.allure.ga.GaParameters;
import io.qameta.allure.ga.GaRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaPlugin
implements Aggregator2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(GaPlugin.class);
    private static final String LOCAL = "local";
    private static final String GA_ENDPOINT_FORMAT = "https://www.google-analytics.com/mp/collect?measurement_id=%s&api_secret=%s";
    private static final String MEASUREMENT_ID = "G-FVWC4GKEYS";
    private static final String GA_SECRET = "rboZz0HySdmCVIvtydmSTQ";
    private static final String GA_EVENT_NAME = "report_generated";

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        if (Objects.nonNull(System.getenv("ALLURE_NO_ANALYTICS"))) {
            LOGGER.debug("analytics is disabled");
            return;
        }
        LOGGER.debug("send analytics");
        GaParameters parameters = new GaParameters().setReportUuid(configuration.getUuid()).setAllureVersion(configuration.getVersion()).setExecutorType(GaPlugin.getExecutorType(launchesResults)).setResultsCount(GaPlugin.getTestResultsCount(launchesResults)).setResultsFormat(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.RESULT_FORMAT)).setFramework(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.FRAMEWORK)).setLanguage(GaPlugin.getLabelValuesAsString(launchesResults, LabelName.LANGUAGE));
        String cid = GaPlugin.getClientId(launchesResults);
        try {
            CompletableFuture.runAsync(() -> this.sendStats(cid, parameters)).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOGGER.debug("Could not send analytics within 10 seconds", (Throwable)e);
        }
    }

    protected void sendStats(String clientId, GaParameters parameters) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        try (CloseableHttpClient client = builder.build();){
            String uri = String.format(GA_ENDPOINT_FORMAT, MEASUREMENT_ID, GA_SECRET);
            HttpPost post = new HttpPost(uri);
            String stringBody = new JsonMapper().writeValueAsString((Object)new GaRequest().setClientId(clientId).setEvents(Collections.singletonList(new GaEvent().setName(GA_EVENT_NAME).setParams(parameters))));
            StringEntity entity = new StringEntity(stringBody, ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8));
            post.setEntity((HttpEntity)entity);
            client.execute((HttpUriRequest)post).close();
            LOGGER.debug("GA done");
        }
        catch (IOException e) {
            LOGGER.debug("Could not send analytics", (Throwable)e);
        }
    }

    private static String getClientId(List<LaunchResults> launchesResults) {
        return ExecutorPlugin.getLatestExecutor(launchesResults).map(ExecutorInfo::getBuildUrl).flatMap(GaPlugin::getHostSafe).map(DigestUtils::sha256Hex).orElseGet(() -> GaPlugin.getLocalHostName().map(DigestUtils::sha256Hex).orElse(UUID.randomUUID().toString()));
    }

    private static Optional<String> getHostSafe(String url) {
        try {
            return Optional.of(URI.create(url)).map(URI::getHost);
        }
        catch (Exception e) {
            LOGGER.debug("invalid build url", (Throwable)e);
            return Optional.empty();
        }
    }

    static String getExecutorType(List<LaunchResults> launchesResults) {
        return ExecutorPlugin.getLatestExecutor(launchesResults).map(ExecutorInfo::getType).map(String::trim).map(String::toLowerCase).orElse(LOCAL);
    }

    private static long getTestResultsCount(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(LaunchResults::getResults).mapToLong(Collection::size).sum();
    }

    private static String getLabelValuesAsString(List<LaunchResults> launchesResults, LabelName labelName) {
        String values = launchesResults.stream().flatMap(results -> results.getResults().stream()).flatMap(result -> result.getLabels().stream()).filter(label -> labelName.value().equals(label.getName())).map(Label::getValue).distinct().sorted().collect(Collectors.joining(" ")).toLowerCase();
        return values.isEmpty() ? "Undefined" : values;
    }

    private static Optional<String> getLocalHostName() {
        try {
            return Optional.ofNullable(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            LOGGER.debug("Could not get host name", (Throwable)e);
            return Optional.empty();
        }
    }
}

