/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.category;

import com.fasterxml.jackson.core.type.TypeReference;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.CommonCsvExportAggregator2;
import io.qameta.allure.CommonJsonAggregator2;
import io.qameta.allure.CompositeAggregator2;
import io.qameta.allure.Reader;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.category.Category;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.csv.CsvExportCategory;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.tree.DefaultTreeLayer;
import io.qameta.allure.tree.TestResultTree;
import io.qameta.allure.tree.TestResultTreeGroup;
import io.qameta.allure.tree.Tree;
import io.qameta.allure.tree.TreeLayer;
import io.qameta.allure.tree.TreeUtils;
import io.qameta.allure.tree.TreeWidgetData;
import io.qameta.allure.tree.TreeWidgetItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CategoriesPlugin
extends CompositeAggregator2
implements Reader {
    public static final String CATEGORIES = "categories";
    public static final Category FAILED_TESTS = new Category().setName("Product defects");
    public static final Category BROKEN_TESTS = new Category().setName("Test defects");
    public static final String JSON_FILE_NAME = "categories.json";
    public static final String CSV_FILE_NAME = "categories.csv";
    private static final TypeReference<List<Category>> CATEGORIES_TYPE = new TypeReference<List<Category>>(){};

    public CategoriesPlugin() {
        super(Arrays.asList(new Aggregator2[]{new EnrichDataAggregator(), new JsonAggregator(), new CsvExportAggregator(), new WidgetAggregator()}));
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path categoriesFile = directory.resolve(JSON_FILE_NAME);
        if (Files.exists(categoriesFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(categoriesFile, new OpenOption[0]);){
                List categories = (List)context.getValue().readValue(is, CATEGORIES_TYPE);
                visitor.visitExtra(CATEGORIES, (Object)categories);
            }
            catch (IOException e) {
                visitor.error("Could not read categories file " + categoriesFile, (Exception)e);
            }
        }
    }

    static Tree<TestResult> getData(List<LaunchResults> launchResults) {
        TestResultTree categories = new TestResultTree(CATEGORIES, CategoriesPlugin::groupByCategories);
        launchResults.stream().map(LaunchResults::getResults).flatMap(Collection::stream).sorted(TestResult.comparingByTimeAsc()).forEach(arg_0 -> ((Tree)categories).add(arg_0));
        return categories;
    }

    static void addCategoriesForResults(List<LaunchResults> launchesResults) {
        launchesResults.forEach(launch -> {
            List categories = (List)launch.getExtra(CATEGORIES, Collections::emptyList);
            launch.getResults().forEach(result -> {
                List resultCategories = (List)result.getExtraBlock(CATEGORIES, new ArrayList());
                categories.forEach(category -> {
                    if (CategoriesPlugin.matches(result, category)) {
                        resultCategories.add(category);
                    }
                });
                if (resultCategories.isEmpty() && Status.FAILED.equals((Object)result.getStatus())) {
                    ((ArrayList)result.getExtraBlock(CATEGORIES, new ArrayList())).add(FAILED_TESTS);
                }
                if (resultCategories.isEmpty() && Status.BROKEN.equals((Object)result.getStatus())) {
                    ((ArrayList)result.getExtraBlock(CATEGORIES, new ArrayList())).add(BROKEN_TESTS);
                }
            });
        });
    }

    protected static List<TreeLayer> groupByCategories(TestResult testResult) {
        Set categories = ((List)testResult.getExtraBlock(CATEGORIES, new ArrayList())).stream().map(Category::getName).collect(Collectors.toSet());
        DefaultTreeLayer categoriesLayer = new DefaultTreeLayer(categories);
        DefaultTreeLayer messageLayer = new DefaultTreeLayer(new String[]{testResult.getStatusMessage()});
        return Arrays.asList(categoriesLayer, messageLayer);
    }

    public static boolean matches(TestResult result, Category category) {
        boolean matchesStatus = category.getMatchedStatuses().isEmpty() || Objects.nonNull(result.getStatus()) && category.getMatchedStatuses().contains(result.getStatus());
        boolean matchesMessage = Objects.isNull(category.getMessageRegex()) || Objects.nonNull(result.getStatusMessage()) && CategoriesPlugin.matches(result.getStatusMessage(), category.getMessageRegex());
        boolean matchesTrace = Objects.isNull(category.getTraceRegex()) || Objects.nonNull(result.getStatusTrace()) && CategoriesPlugin.matches(result.getStatusTrace(), category.getTraceRegex());
        boolean matchesFlaky = result.isFlaky() == category.isFlaky();
        return matchesStatus && matchesMessage && matchesTrace && matchesFlaky;
    }

    private static boolean matches(String message, String pattern) {
        return Pattern.compile(pattern, 32).matcher(message).matches();
    }

    protected static TreeWidgetItem toWidgetItem(TestResultTreeGroup group) {
        return new TreeWidgetItem().setUid(group.getUid()).setName(group.getName()).setStatistic(TreeUtils.calculateStatisticByLeafs((TestResultTreeGroup)group));
    }

    private static final class EnrichDataAggregator
    implements Aggregator2 {
        private EnrichDataAggregator() {
        }

        public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
            CategoriesPlugin.addCategoriesForResults(launchesResults);
        }
    }

    private static final class JsonAggregator
    extends CommonJsonAggregator2 {
        JsonAggregator() {
            super(CategoriesPlugin.JSON_FILE_NAME);
        }

        protected Tree<TestResult> getData(List<LaunchResults> launches) {
            return CategoriesPlugin.getData(launches);
        }
    }

    private static final class CsvExportAggregator
    extends CommonCsvExportAggregator2<CsvExportCategory> {
        CsvExportAggregator() {
            super(CategoriesPlugin.CSV_FILE_NAME, CsvExportCategory.class);
        }

        protected List<CsvExportCategory> getData(List<LaunchResults> launchesResults) {
            ArrayList<CsvExportCategory> exportLabels = new ArrayList<CsvExportCategory>();
            Tree<TestResult> data = CategoriesPlugin.getData(launchesResults);
            List<TreeWidgetItem> items = data.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).map(CategoriesPlugin::toWidgetItem).sorted(Comparator.comparing(TreeWidgetItem::getStatistic, Statistic.comparator()).reversed()).collect(Collectors.toList());
            items.forEach(item -> exportLabels.add(new CsvExportCategory(item)));
            return exportLabels;
        }
    }

    private static final class WidgetAggregator
    extends CommonJsonAggregator2 {
        WidgetAggregator() {
            super("widgets", CategoriesPlugin.JSON_FILE_NAME);
        }

        protected Object getData(List<LaunchResults> launches) {
            Tree<TestResult> data = CategoriesPlugin.getData(launches);
            List items = data.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).map(CategoriesPlugin::toWidgetItem).sorted(Comparator.comparing(TreeWidgetItem::getStatistic, Statistic.comparator()).reversed()).limit(10L).collect(Collectors.toList());
            return new TreeWidgetData().setItems(items).setTotal((long)data.getChildren().size());
        }
    }
}

