/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.trx;

import io.qameta.allure.Reader;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.Label;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Step;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import io.qameta.allure.parser.ClasspathEntityResolver;
import io.qameta.allure.parser.XmlElement;
import io.qameta.allure.trx.UnitTest;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class TrxPlugin
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrxPlugin.class);
    private static final String TEST_RUN_ELEMENT_NAME = "TestRun";
    public static final String TRX_RESULTS_FORMAT = "trx";
    public static final String RESULTS_ELEMENT_NAME = "Results";
    public static final String UNIT_TEST_RESULT_ELEMENT_NAME = "UnitTestResult";
    public static final String UNIT_TEST_INNER_RESULTS = "InnerResults";
    public static final String TEST_NAME_ATTRIBUTE = "testName";
    public static final String START_TIME_ATTRIBUTE = "startTime";
    public static final String END_TIME_ATTRIBUTE = "endTime";
    public static final String OUTCOME_ATTRIBUTE = "outcome";
    public static final String TEST_DEFINITIONS_ELEMENT = "TestDefinitions";
    public static final String UNIT_TEST_ELEMENT = "UnitTest";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String TEST_METHOD_ELEMENT = "TestMethod";
    public static final String CLASS_NAME_ATTRIBUTE = "className";
    public static final String PROPERTIES_ELEMENT = "Properties";
    public static final String PROPERTY_ATTRIBUTE = "Property";
    public static final String KEY_ELEMENT = "Key";
    public static final String VALUE_ELEMENT = "Value";
    public static final String DESCRIPTION_ELEMENT = "Description";
    public static final String EXECUTION_ELEMENT = "Execution";
    public static final String ID_ATTRIBUTE = "id";
    public static final String EXECUTION_ID_ATTRIBUTE = "executionId";
    public static final String OUTPUT_ELEMENT_NAME = "Output";
    public static final String MESSAGE_ELEMENT_NAME = "Message";
    public static final String STACK_TRACE_ELEMENT_NAME = "StackTrace";
    public static final String ERROR_INFO_ELEMENT_NAME = "ErrorInfo";
    public static final String STDOUT_ELEMENT_NAME = "StdOut";

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        TrxPlugin.listResults(directory).forEach(result -> this.parseTestRun((Path)result, context, visitor));
    }

    protected void parseTestRun(Path parsedFile, RandomUidContext context, ResultsVisitor visitor) {
        try {
            LOGGER.debug("Parsing file {}", (Object)parsedFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)new ClasspathEntityResolver());
            Document document = builder.parse(parsedFile.toFile());
            XmlElement testRunElement = new XmlElement(document.getDocumentElement());
            String elementName = testRunElement.getName();
            if (!TEST_RUN_ELEMENT_NAME.equals(elementName)) {
                LOGGER.debug("{} is not a valid TRX file. Unknown root element {}", (Object)parsedFile, (Object)elementName);
                return;
            }
            HashMap tests = new HashMap();
            testRunElement.getFirst(TEST_DEFINITIONS_ELEMENT).ifPresent(testDefinitions -> testDefinitions.get(UNIT_TEST_ELEMENT).forEach(unitTestElement -> {
                UnitTest unitTest = this.parseUnitTest((XmlElement)unitTestElement);
                tests.put(unitTest.getExecutionId(), unitTest);
            }));
            testRunElement.getFirst(RESULTS_ELEMENT_NAME).ifPresent(resultsElement -> this.parseResults((XmlElement)resultsElement, tests, context, visitor));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.error("Could not parse file {}", (Object)parsedFile, (Object)e);
        }
    }

    protected UnitTest parseUnitTest(XmlElement unitTestElement) {
        String name = unitTestElement.getAttribute(NAME_ATTRIBUTE);
        String className = unitTestElement.getFirst(TEST_METHOD_ELEMENT).map(testMethod -> testMethod.getAttribute(CLASS_NAME_ATTRIBUTE)).orElse(null);
        String description = unitTestElement.getFirst(DESCRIPTION_ELEMENT).map(XmlElement::getValue).orElse(null);
        String executionId = unitTestElement.getFirst(EXECUTION_ELEMENT).map(execution -> execution.getAttribute(ID_ATTRIBUTE)).orElse(null);
        Map<String, String> properties = this.parseProperties(unitTestElement);
        return new UnitTest(name, className, executionId, description, properties);
    }

    private Map<String, String> parseProperties(XmlElement unitTestElement) {
        HashMap<String, String> properties = new HashMap<String, String>();
        unitTestElement.getFirst(PROPERTIES_ELEMENT).ifPresent(propertiesElement -> this.parseProperties((Map<String, String>)properties, (XmlElement)propertiesElement));
        return properties;
    }

    private void parseProperties(Map<String, String> properties, XmlElement propertiesElement) {
        propertiesElement.get(PROPERTY_ATTRIBUTE).forEach(propertyElement -> this.parseProperty(properties, (XmlElement)propertyElement));
    }

    private void parseProperty(Map<String, String> properties, XmlElement propertyElement) {
        Optional<String> key = propertyElement.getFirst(KEY_ELEMENT).map(XmlElement::getValue);
        Optional<String> value = propertyElement.getFirst(VALUE_ELEMENT).map(XmlElement::getValue);
        if (key.isPresent() && value.isPresent()) {
            properties.put(key.get(), value.get());
        }
    }

    protected void parseResults(XmlElement resultsElement, Map<String, UnitTest> tests, RandomUidContext context, ResultsVisitor visitor) {
        resultsElement.get(UNIT_TEST_RESULT_ELEMENT_NAME).forEach(unitTestResult -> this.parseUnitTestResult((XmlElement)unitTestResult, tests, context, visitor));
    }

    protected void parseUnitTestResult(XmlElement unitTestResult, Map<String, UnitTest> tests, RandomUidContext context, ResultsVisitor visitor) {
        String executionId = unitTestResult.getAttribute(EXECUTION_ID_ATTRIBUTE);
        String testName = unitTestResult.getAttribute(TEST_NAME_ATTRIBUTE);
        String startTime = unitTestResult.getAttribute(START_TIME_ATTRIBUTE);
        String endTime = unitTestResult.getAttribute(END_TIME_ATTRIBUTE);
        String outcome = unitTestResult.getAttribute(OUTCOME_ATTRIBUTE);
        String uid = (String)context.getValue().get();
        TestResult result = new TestResult().setUid(uid).setName(testName).setStatus(this.parseStatus(outcome)).setTime(this.getTime(startTime, endTime));
        this.getStatusMessage(unitTestResult).ifPresent(arg_0 -> ((TestResult)result).setStatusMessage(arg_0));
        this.getStatusTrace(unitTestResult).ifPresent(arg_0 -> ((TestResult)result).setStatusTrace(arg_0));
        this.getLogMessage(unitTestResult).ifPresent(logMessage -> {
            List<String> lines = this.splitLines((String)logMessage);
            List steps = lines.stream().map(line -> new Step().setName(line)).collect(Collectors.toList());
            StageResult stageResult = new StageResult().setSteps(steps);
            result.setTestStage(stageResult);
        });
        Optional.ofNullable(tests.get(executionId)).ifPresent(unitTest -> {
            String className = unitTest.getClassName();
            String fullName = String.format("%s.%s", className, testName);
            result.setParameters(unitTest.getParameters());
            result.setDescription(unitTest.getDescription());
            result.setFullName(fullName);
            result.setHistoryId(fullName);
            result.addLabelIfNotExists(LabelName.SUITE, className);
            result.addLabelIfNotExists(LabelName.TEST_CLASS, className);
            result.addLabelIfNotExists(LabelName.PACKAGE, className);
        });
        result.addLabelIfNotExists(LabelName.RESULT_FORMAT, TRX_RESULTS_FORMAT);
        visitor.visitTestResult(result);
        unitTestResult.getFirst(UNIT_TEST_INNER_RESULTS).ifPresent(innerResults -> innerResults.get(UNIT_TEST_RESULT_ELEMENT_NAME).forEach(unitTestChildResult -> this.parseUnitTestResult((XmlElement)unitTestChildResult, tests, context, visitor, result.getLabels())));
    }

    protected void parseUnitTestResult(XmlElement unitTestResult, Map<String, UnitTest> tests, RandomUidContext context, ResultsVisitor visitor, List<Label> labels) {
        String testName = unitTestResult.getAttribute(TEST_NAME_ATTRIBUTE);
        String startTime = unitTestResult.getAttribute(START_TIME_ATTRIBUTE);
        String endTime = unitTestResult.getAttribute(END_TIME_ATTRIBUTE);
        String outcome = unitTestResult.getAttribute(OUTCOME_ATTRIBUTE);
        String uid = (String)context.getValue().get();
        TestResult result = new TestResult().setUid(uid).setName(testName).setStatus(this.parseStatus(outcome)).setTime(this.getTime(startTime, endTime));
        this.getStatusMessage(unitTestResult).ifPresent(arg_0 -> ((TestResult)result).setStatusMessage(arg_0));
        this.getStatusTrace(unitTestResult).ifPresent(arg_0 -> ((TestResult)result).setStatusTrace(arg_0));
        this.getLogMessage(unitTestResult).ifPresent(logMessage -> {
            List<String> lines = this.splitLines((String)logMessage);
            List steps = lines.stream().map(line -> new Step().setName(line)).collect(Collectors.toList());
            StageResult stageResult = new StageResult().setSteps(steps);
            result.setTestStage(stageResult);
        });
        labels.forEach(label -> result.addLabelIfNotExists(label.getName(), label.getValue()));
        visitor.visitTestResult(result);
        unitTestResult.getFirst(UNIT_TEST_INNER_RESULTS).ifPresent(innerResults -> innerResults.get(UNIT_TEST_RESULT_ELEMENT_NAME).forEach(unitTestChildResult -> this.parseUnitTestResult((XmlElement)unitTestChildResult, tests, context, visitor, result.getLabels())));
    }

    private List<String> splitLines(String str) {
        return Arrays.asList(str.split("\\r?\\n"));
    }

    private Optional<String> getLogMessage(XmlElement unitTestResult) {
        return unitTestResult.getFirst(OUTPUT_ELEMENT_NAME).flatMap(output -> output.getFirst(STDOUT_ELEMENT_NAME)).map(XmlElement::getValue);
    }

    private Optional<String> getStatusMessage(XmlElement unitTestResult) {
        return unitTestResult.getFirst(OUTPUT_ELEMENT_NAME).flatMap(output -> output.getFirst(ERROR_INFO_ELEMENT_NAME)).flatMap(output -> output.getFirst(MESSAGE_ELEMENT_NAME)).map(XmlElement::getValue);
    }

    private Optional<String> getStatusTrace(XmlElement unitTestResult) {
        return unitTestResult.getFirst(OUTPUT_ELEMENT_NAME).flatMap(output -> output.getFirst(ERROR_INFO_ELEMENT_NAME)).flatMap(output -> output.getFirst(STACK_TRACE_ELEMENT_NAME)).map(XmlElement::getValue);
    }

    private Time getTime(String startTime, String endTime) {
        Time time = new Time();
        this.parseTime(startTime).ifPresent(arg_0 -> ((Time)time).setStart(arg_0));
        this.parseTime(endTime).ifPresent(arg_0 -> ((Time)time).setStop(arg_0));
        if (Objects.nonNull(time.getStart()) && Objects.nonNull(time.getStop())) {
            time.setDuration(Long.valueOf(time.getStop() - time.getStart()));
        }
        return time;
    }

    protected Status parseStatus(String outcome) {
        if (Objects.isNull(outcome)) {
            return Status.UNKNOWN;
        }
        switch (outcome.toLowerCase()) {
            case "passed": {
                return Status.PASSED;
            }
            case "failed": {
                return Status.FAILED;
            }
            case "notexecuted": {
                return Status.SKIPPED;
            }
        }
        return Status.UNKNOWN;
    }

    protected Optional<Long> parseTime(String time) {
        try {
            return Optional.ofNullable(time).map(ZonedDateTime::parse).map(ChronoZonedDateTime::toInstant).map(Instant::toEpochMilli);
        }
        catch (Exception e) {
            LOGGER.error("Could not parse time {}", (Object)time, (Object)e);
            return Optional.empty();
        }
    }

    private static List<Path> listResults(Path directory) {
        ArrayList<Path> result = new ArrayList<Path>();
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(directory, "*.trx");){
            for (Path path : directoryStream) {
                if (Files.isDirectory(path, new LinkOption[0])) continue;
                result.add(path);
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not read data from {}", (Object)directory, (Object)e);
        }
        return result;
    }
}

