/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import xmlwise.XmlElement;
import xmlwise.XmlParseException;

public class Xmlwise {
    private Xmlwise() {
    }

    public static Document loadDocument(File file) throws IOException, XmlParseException {
        return Xmlwise.loadDocument(file, false, false);
    }

    public static Document loadDocument(File file, boolean validate, boolean loadExternalDTD) throws IOException, XmlParseException {
        try {
            return Xmlwise.getBuilderFactory(validate, loadExternalDTD).parse(file);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlParseException(e);
        }
    }

    private static DocumentBuilder getBuilderFactory(boolean validate, boolean loadExternalDTD) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", loadExternalDTD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        documentBuilderFactory.setValidating(validate);
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static Document createDocument(String xml, boolean validate, boolean loadExternalDTD) throws XmlParseException {
        try {
            return Xmlwise.getBuilderFactory(validate, loadExternalDTD).parse(new InputSource(new StringReader(xml)));
        }
        catch (Exception e) {
            throw new XmlParseException(e);
        }
    }

    public static Document createDocument(String xml) throws XmlParseException {
        return Xmlwise.createDocument(xml, false, false);
    }

    public static String escapeXML(String stringToEscape) {
        int size = stringToEscape.length();
        if (size == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder(size);
        block7: for (int i = 0; i < size; ++i) {
            char c = stringToEscape.charAt(i);
            switch (c) {
                case '<': {
                    s.append("&lt;");
                    continue block7;
                }
                case '>': {
                    s.append("&gt;");
                    continue block7;
                }
                case '&': {
                    s.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    s.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    s.append("&apos;");
                    continue block7;
                }
                default: {
                    s.append(c);
                }
            }
        }
        return s.toString();
    }

    public static XmlElement loadXml(File file) throws XmlParseException, IOException {
        return new XmlElement(Xmlwise.loadDocument(file).getDocumentElement());
    }

    public static XmlElement loadXml(String filename) throws XmlParseException, IOException {
        return Xmlwise.loadXml(new File(filename));
    }

    public static XmlElement createXml(String xml) throws XmlParseException {
        return new XmlElement(Xmlwise.createDocument(xml).getDocumentElement());
    }
}

