/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.summary;

import io.qameta.allure.Aggregator2;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.GroupTime;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Statusable;
import io.qameta.allure.entity.Timeable;
import io.qameta.allure.executor.ExecutorPlugin;
import io.qameta.allure.summary.SummaryData;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SummaryPlugin
implements Aggregator2 {
    protected static final String JSON_FILE_NAME = "summary.json";

    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        SummaryData data1 = new SummaryData().setStatistic(new Statistic()).setTime(new GroupTime()).setReportName(SummaryPlugin.getReportName(configuration, launchesResults));
        launchesResults.stream().map(LaunchResults::getResults).flatMap(Collection::stream).forEach(result -> {
            data1.getStatistic().update((Statusable)result);
            data1.getTime().update((Timeable)result);
        });
        storage.addDataJson(String.format("%s/%s", "widgets", JSON_FILE_NAME), (Object)data1);
    }

    private static String getReportName(Configuration configuration, List<LaunchResults> launchesResults) {
        String reportName = configuration.getReportName();
        if (Objects.nonNull(reportName)) {
            return reportName;
        }
        return ExecutorPlugin.getLatestExecutor(launchesResults).map(ExecutorInfo::getReportName).map(String::trim).orElse("Allure Report");
    }
}

