/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.history;

import com.fasterxml.jackson.core.type.TypeReference;
import io.qameta.allure.CommonJsonAggregator2;
import io.qameta.allure.Reader;
import io.qameta.allure.context.JacksonContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.Statusable;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.history.HistoryData;
import io.qameta.allure.history.HistoryItem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HistoryPlugin
extends CommonJsonAggregator2
implements Reader {
    private static final Set<Status> MARK_STATUSES = new HashSet<Status>(Arrays.asList(Status.FAILED, Status.BROKEN, Status.PASSED));
    private static final String HISTORY_BLOCK_NAME = "history";
    private static final String HISTORY_FILE_NAME = "history.json";
    private static final TypeReference<Map<String, HistoryData>> HISTORY_TYPE = new TypeReference<Map<String, HistoryData>>(){};

    public HistoryPlugin() {
        super(HISTORY_BLOCK_NAME, HISTORY_FILE_NAME);
    }

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path directory) {
        JacksonContext context = (JacksonContext)configuration.requireContext(JacksonContext.class);
        Path historyFile = directory.resolve(HISTORY_BLOCK_NAME).resolve(HISTORY_FILE_NAME);
        if (Files.exists(historyFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(historyFile, new OpenOption[0]);){
                Map history = (Map)context.getValue().readValue(is, HISTORY_TYPE);
                visitor.visitExtra(HISTORY_BLOCK_NAME, (Object)history);
            }
            catch (IOException e) {
                visitor.error("Could not read history file " + historyFile, (Exception)e);
            }
        }
    }

    private boolean isNewFailed(HistoryItem current, List<HistoryItem> prev) {
        return this.statusChangeTo(Status.FAILED, current, prev);
    }

    private boolean isNewBroken(HistoryItem current, List<HistoryItem> prev) {
        return this.statusChangeTo(Status.BROKEN, current, prev);
    }

    private boolean isNewPassed(HistoryItem current, List<HistoryItem> prev) {
        return this.statusChangeTo(Status.PASSED, current, prev);
    }

    private boolean statusChangeTo(Status target, HistoryItem current, List<HistoryItem> prev) {
        Optional<HistoryItem> prevItem = prev.stream().filter(hi -> MARK_STATUSES.contains(hi.getStatus())).findFirst();
        return prevItem.isPresent() && target.equals((Object)current.getStatus()) && !target.equals((Object)prevItem.get().getStatus());
    }

    private boolean isFlaky(HistoryItem current, List<HistoryItem> prev) {
        if (prev.isEmpty()) {
            return false;
        }
        if (current.getStatus() != Status.FAILED && current.getStatus() != Status.BROKEN) {
            return false;
        }
        List statuses = prev.stream().map(HistoryItem::getStatus).limit(5L).collect(Collectors.toList());
        return statuses.contains(Status.PASSED) && statuses.indexOf(Status.PASSED) < statuses.lastIndexOf(Status.FAILED);
    }

    protected Map<String, HistoryData> getData(List<LaunchResults> launches) {
        Map history = launches.stream().map(launch -> (Map)launch.getExtra(HISTORY_BLOCK_NAME, HashMap::new)).reduce(new HashMap(), (a, b) -> {
            a.putAll(b);
            return a;
        });
        launches.forEach(launch -> {
            ExecutorInfo executorInfo = (ExecutorInfo)launch.getExtra("executor", ExecutorInfo::new);
            launch.getResults().stream().filter(result -> Objects.nonNull(result.getHistoryId())).forEach(result -> this.updateHistory(history, (TestResult)result, executorInfo));
        });
        return history;
    }

    private void updateHistory(Map<String, HistoryData> history, TestResult result, ExecutorInfo info) {
        HistoryData data = history.computeIfAbsent(result.getHistoryId(), id -> new HistoryData().setStatistic(new Statistic()));
        data.getStatistic().update((Statusable)result);
        if (!data.getItems().isEmpty()) {
            result.addExtraBlock(HISTORY_BLOCK_NAME, (Object)HistoryPlugin.copy(data));
        }
        HistoryItem current = new HistoryItem().setUid(result.getUid()).setStatus(result.getStatus()).setStatusDetails(result.getStatusMessage()).setTime(result.getTime());
        if (Objects.nonNull(info.getReportUrl())) {
            current.setReportUrl(HistoryPlugin.createReportUrl(info.getReportUrl(), result.getUid()));
        }
        List<HistoryItem> prevItems = data.getItems();
        result.setFlaky(result.isFlaky() || this.isFlaky(current, prevItems));
        result.setNewFailed(this.isNewFailed(current, prevItems));
        result.setNewBroken(this.isNewBroken(current, prevItems));
        result.setNewPassed(this.isNewPassed(current, prevItems));
        List<HistoryItem> newItems = Stream.concat(Stream.of(current), prevItems.stream()).limit(20L).collect(Collectors.toList());
        data.setItems(newItems);
    }

    private static HistoryData copy(HistoryData other) {
        Statistic statistic = new Statistic();
        statistic.merge(other.getStatistic());
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>(other.getItems());
        return new HistoryData().setStatistic(statistic).setItems(items);
    }

    private static String createReportUrl(String reportUrl, String uuid) {
        String pattern = reportUrl.endsWith("index.html") ? "%s#testresult/%s" : "%s/#testresult/%s";
        return String.format(pattern, reportUrl, uuid);
    }
}

