/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.allure1;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import io.qameta.allure.Reader;
import io.qameta.allure.allure1.XmlParserModule;
import io.qameta.allure.context.RandomUidContext;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.ResultsVisitor;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Parameter;
import io.qameta.allure.entity.StageResult;
import io.qameta.allure.entity.Status;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.entity.Time;
import io.qameta.allure.util.ConvertUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.allurefw.allure1.AllureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.allure.model.Attachment;
import ru.yandex.qatools.allure.model.Description;
import ru.yandex.qatools.allure.model.DescriptionType;
import ru.yandex.qatools.allure.model.Label;
import ru.yandex.qatools.allure.model.ParameterKind;
import ru.yandex.qatools.allure.model.Step;
import ru.yandex.qatools.allure.model.TestCaseResult;
import ru.yandex.qatools.allure.model.TestSuiteResult;
import ru.yandex.qatools.commons.model.Environment;

public class Allure1Plugin
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Allure1Plugin.class);
    private static final String UNKNOWN = "unknown";
    private static final String MD_5 = "md5";
    private static final String ISSUE_URL_PROPERTY = "allure.issues.tracker.pattern";
    private static final String TMS_LINK_PROPERTY = "allure.tests.management.pattern";
    private static final Comparator<Parameter> PARAMETER_COMPARATOR = Comparator.comparing(Parameter::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(Parameter::getValue, Comparator.nullsFirst(Comparator.naturalOrder()));
    public static final String ENVIRONMENT_BLOCK_NAME = "environment";
    public static final String ALLURE1_RESULTS_FORMAT = "allure1";
    private final ObjectMapper jsonMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS})).build();
    private final ObjectMapper xmlMapper = ((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)XmlMapper.builder().enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).enable(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS})).annotationIntrospector((AnnotationIntrospector)new JaxbAnnotationIntrospector(TypeFactory.defaultInstance()))).addModule((Module)new XmlParserModule())).build();

    public void readResults(Configuration configuration, ResultsVisitor visitor, Path resultsDirectory) {
        Properties allureProperties = this.loadAllureProperties(resultsDirectory);
        RandomUidContext context = (RandomUidContext)configuration.requireContext(RandomUidContext.class);
        Map<String, String> environment = this.processEnvironment(resultsDirectory);
        this.getStreamOfAllure1Results(resultsDirectory).forEach(testSuite -> testSuite.getTestCases().forEach(testCase -> {
            this.convert(context.getValue(), resultsDirectory, visitor, (TestSuiteResult)testSuite, (TestCaseResult)testCase, allureProperties);
            this.getEnvironmentParameters((TestCaseResult)testCase).forEach(param -> environment.put(param.getName(), param.getValue()));
        }));
        visitor.visitExtra(ENVIRONMENT_BLOCK_NAME, environment);
    }

    private List<ru.yandex.qatools.allure.model.Parameter> getEnvironmentParameters(TestCaseResult testCase) {
        return testCase.getParameters().stream().filter(this::hasEnvType).collect(Collectors.toList());
    }

    private Properties loadAllureProperties(Path resultsDirectory) {
        Path propertiesFile = resultsDirectory.resolve("allure.properties");
        Properties properties = new Properties();
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            try (InputStream propFile = Files.newInputStream(propertiesFile, new OpenOption[0]);){
                properties.load(propFile);
            }
            catch (IOException e) {
                LOGGER.error("Error while reading allure.properties file: {}", (Object)e.getMessage());
            }
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    private void convert(Supplier<String> randomUid, Path directory, ResultsVisitor visitor, TestSuiteResult testSuite, TestCaseResult source, Properties properties) {
        TestResult dest = new TestResult();
        String suiteName = Allure1Plugin.firstNonNull(testSuite.getTitle(), testSuite.getName(), "unknown test suite");
        String testClass = Allure1Plugin.firstNonNull(this.findLabelValue(source.getLabels(), LabelName.TEST_CLASS.value()), this.findLabelValue(testSuite.getLabels(), LabelName.TEST_CLASS.value()), testSuite.getName(), UNKNOWN);
        String testMethod = Allure1Plugin.firstNonNull(this.findLabelValue(source.getLabels(), LabelName.TEST_METHOD.value()), source.getName(), UNKNOWN);
        String name = Allure1Plugin.firstNonNull(source.getTitle(), source.getName(), "unknown test case");
        List<Parameter> parameters = this.getParameters(source);
        Optional<Label> historyId = this.findLabel(source.getLabels(), "historyId");
        if (historyId.isPresent()) {
            dest.setHistoryId(historyId.get().getValue());
        } else {
            dest.setHistoryId(Allure1Plugin.getHistoryId(String.format("%s#%s", testClass, name), parameters));
        }
        dest.setUid(randomUid.get());
        dest.setName(name);
        dest.setFullName(String.format("%s.%s", testClass, testMethod));
        Status status = Allure1Plugin.convert(source.getStatus());
        dest.setStatus(status);
        dest.setTime(Time.create((Long)source.getStart(), (Long)source.getStop()));
        dest.setParameters(parameters);
        dest.setDescription(this.getDescription(testSuite.getDescription(), source.getDescription()));
        dest.setDescriptionHtml(this.getDescriptionHtml(testSuite.getDescription(), source.getDescription()));
        Optional.ofNullable(source.getFailure()).ifPresent(failure -> {
            dest.setStatusMessage(failure.getMessage());
            dest.setStatusTrace(failure.getStackTrace());
        });
        if (!source.getSteps().isEmpty() || !source.getAttachments().isEmpty()) {
            StageResult testStage = new StageResult();
            if (!source.getSteps().isEmpty()) {
                testStage.setSteps(ConvertUtils.convertList((Collection)source.getSteps(), step -> this.convert(directory, visitor, (Step)step, status, dest.getStatusMessage(), dest.getStatusTrace())));
            }
            if (!source.getAttachments().isEmpty()) {
                testStage.setAttachments(ConvertUtils.convertList((Collection)source.getAttachments(), at -> this.convert(directory, visitor, (Attachment)at)));
            }
            testStage.setStatus(status);
            testStage.setStatusMessage(dest.getStatusMessage());
            testStage.setStatusTrace(dest.getStatusTrace());
            dest.setTestStage(testStage);
        }
        TreeSet<io.qameta.allure.entity.Label> set = new TreeSet<io.qameta.allure.entity.Label>(Comparator.comparing(io.qameta.allure.entity.Label::getName, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(io.qameta.allure.entity.Label::getValue, Comparator.nullsFirst(Comparator.naturalOrder())));
        set.addAll(ConvertUtils.convertList((Collection)testSuite.getLabels(), this::convert));
        set.addAll(ConvertUtils.convertList((Collection)source.getLabels(), this::convert));
        dest.setLabels(new ArrayList<io.qameta.allure.entity.Label>(set));
        dest.findAllLabels(LabelName.ISSUE).forEach(issue -> dest.getLinks().add(this.getLink(LabelName.ISSUE, (String)issue, this.getIssueUrl((String)issue, properties))));
        dest.findOneLabel("testId").ifPresent(testId -> dest.getLinks().add(new Link().setName(testId).setType("tms").setUrl(this.getTestCaseIdUrl((String)testId, properties))));
        Optional testGroupLabel = dest.findOneLabel("testGroup");
        Optional testSuiteLabel = dest.findOneLabel("testSuite");
        if (testGroupLabel.isPresent() && testSuiteLabel.isPresent()) {
            dest.addLabelIfNotExists(LabelName.PARENT_SUITE, (String)testSuiteLabel.get());
            dest.addLabelIfNotExists(LabelName.SUITE, (String)testGroupLabel.get());
            dest.addLabelIfNotExists(LabelName.SUB_SUITE, testClass);
        } else {
            dest.addLabelIfNotExists(LabelName.SUITE, suiteName);
        }
        dest.addLabelIfNotExists(LabelName.TEST_CLASS, testClass);
        dest.addLabelIfNotExists(LabelName.TEST_METHOD, testMethod);
        dest.addLabelIfNotExists(LabelName.PACKAGE, testClass);
        dest.findAllLabels("status_details").stream().filter("flaky"::equalsIgnoreCase).findAny().ifPresent(value -> dest.setFlaky(true));
        dest.addLabelIfNotExists(LabelName.RESULT_FORMAT, ALLURE1_RESULTS_FORMAT);
        visitor.visitTestResult(dest);
    }

    private io.qameta.allure.entity.Step convert(Path source, ResultsVisitor visitor, Step s, Status testStatus, String message, String trace) {
        Status status = Allure1Plugin.convert(s.getStatus());
        io.qameta.allure.entity.Step current = new io.qameta.allure.entity.Step().setName(s.getTitle() == null ? s.getName() : s.getTitle()).setTime(new Time().setStart(Long.valueOf(s.getStart())).setStop(Long.valueOf(s.getStop())).setDuration(Long.valueOf(s.getStop() - s.getStart()))).setStatus(status).setSteps(ConvertUtils.convertList((Collection)s.getSteps(), step -> this.convert(source, visitor, (Step)step, testStatus, message, trace))).setAttachments(ConvertUtils.convertList((Collection)s.getAttachments(), attach -> this.convert(source, visitor, (Attachment)attach)));
        if (Objects.equals(status, testStatus)) {
            current.setStatusMessage(message);
            current.setStatusMessage(trace);
        }
        return current;
    }

    private io.qameta.allure.entity.Label convert(Label label) {
        return new io.qameta.allure.entity.Label().setName(label.getName()).setValue(label.getValue());
    }

    private Parameter convert(ru.yandex.qatools.allure.model.Parameter parameter) {
        return new Parameter().setName(parameter.getName()).setValue(parameter.getValue());
    }

    private io.qameta.allure.entity.Attachment convert(Path source, ResultsVisitor visitor, Attachment attachment) {
        Path attachmentFile = source.resolve(attachment.getSource());
        if (Files.isRegularFile(attachmentFile, new LinkOption[0])) {
            io.qameta.allure.entity.Attachment found = visitor.visitAttachmentFile(attachmentFile);
            if (Objects.nonNull(attachment.getType())) {
                found.setType(attachment.getType());
            }
            if (Objects.nonNull(attachment.getTitle())) {
                found.setName(attachment.getTitle());
            }
            return found;
        }
        visitor.error("Could not find attachment " + attachment.getSource() + " in directory " + source);
        return new io.qameta.allure.entity.Attachment().setType(attachment.getType()).setName(attachment.getTitle()).setSize(Long.valueOf(0L));
    }

    public static Status convert(ru.yandex.qatools.allure.model.Status status) {
        if (Objects.isNull(status)) {
            return Status.UNKNOWN;
        }
        switch (status) {
            case FAILED: {
                return Status.FAILED;
            }
            case BROKEN: {
                return Status.BROKEN;
            }
            case PASSED: {
                return Status.PASSED;
            }
            case CANCELED: 
            case SKIPPED: 
            case PENDING: {
                return Status.SKIPPED;
            }
        }
        return Status.UNKNOWN;
    }

    private List<Parameter> getParameters(TestCaseResult source) {
        List parameters = ConvertUtils.convertList((Collection)source.getParameters(), this::hasArgumentType, this::convert);
        if (Objects.isNull(parameters)) {
            return new ArrayList<Parameter>();
        }
        TreeSet<Parameter> parametersSet = new TreeSet<Parameter>(PARAMETER_COMPARATOR);
        parametersSet.addAll(parameters);
        return new ArrayList<Parameter>(parametersSet);
    }

    private String getDescription(Description ... descriptions) {
        return Stream.of(descriptions).filter(Objects::nonNull).filter(this.isHtmlDescription().negate()).map(Description::getValue).collect(Collectors.joining("\n\n"));
    }

    private String getDescriptionHtml(Description ... descriptions) {
        return Stream.of(descriptions).filter(Objects::nonNull).filter(this.isHtmlDescription()).map(Description::getValue).collect(Collectors.joining("</br>"));
    }

    private Predicate<Description> isHtmlDescription() {
        return description -> DescriptionType.HTML.equals((Object)description.getType());
    }

    private String findLabelValue(List<Label> labels, String labelName) {
        return labels.stream().filter(label -> labelName.equals(label.getName())).map(Label::getValue).findAny().orElse(null);
    }

    private Optional<Label> findLabel(List<Label> labels, String labelName) {
        return labels.stream().filter(label -> labelName.equals(label.getName())).findAny();
    }

    private boolean hasArgumentType(ru.yandex.qatools.allure.model.Parameter parameter) {
        return Objects.isNull(parameter.getKind()) || ParameterKind.ARGUMENT.equals((Object)parameter.getKind());
    }

    private boolean hasEnvType(ru.yandex.qatools.allure.model.Parameter parameter) {
        return ParameterKind.ENVIRONMENT_VARIABLE.equals((Object)parameter.getKind());
    }

    private Link getLink(LabelName labelName, String value, String url) {
        return new Link().setName(value).setType(labelName.value()).setUrl(url);
    }

    private String getIssueUrl(String issue, Properties properties) {
        return String.format(properties.getProperty(ISSUE_URL_PROPERTY, "%s"), issue);
    }

    private String getTestCaseIdUrl(String testCaseId, Properties properties) {
        return String.format(properties.getProperty(TMS_LINK_PROPERTY, "%s"), testCaseId);
    }

    private Stream<TestSuiteResult> getStreamOfAllure1Results(Path source) {
        return Stream.concat(this.xmlFiles(source), this.jsonFiles(source));
    }

    private Stream<TestSuiteResult> xmlFiles(Path source) {
        try {
            return AllureUtils.listTestSuiteXmlFiles((Path[])new Path[]{source}).stream().map(this::readXmlTestSuiteFile).filter(Optional::isPresent).map(Optional::get);
        }
        catch (IOException e) {
            LOGGER.error("Could not list allure1 xml files", (Throwable)e);
            return Stream.empty();
        }
    }

    private Stream<TestSuiteResult> jsonFiles(Path source) {
        try {
            return AllureUtils.listTestSuiteJsonFiles((Path[])new Path[]{source}).stream().map(this::readJsonTestSuiteFile).filter(Optional::isPresent).map(Optional::get);
        }
        catch (IOException e) {
            LOGGER.error("Could not list allure1 json files", (Throwable)e);
            return Stream.empty();
        }
    }

    private Optional<TestSuiteResult> readXmlTestSuiteFile(Path source) {
        Optional<TestSuiteResult> optional;
        block8: {
            InputStream is = Files.newInputStream(source, new OpenOption[0]);
            try {
                optional = Optional.of((TestSuiteResult)this.xmlMapper.readValue(is, TestSuiteResult.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not read xml result {}", (Object)source, (Object)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    private Optional<TestSuiteResult> readJsonTestSuiteFile(Path source) {
        Optional<TestSuiteResult> optional;
        block8: {
            InputStream is = Files.newInputStream(source, new OpenOption[0]);
            try {
                optional = Optional.of((TestSuiteResult)this.jsonMapper.readValue(is, TestSuiteResult.class));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Could not read json result {}", (Object)source, (Object)e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }

    @SafeVarargs
    private static <T> T firstNonNull(T ... items) {
        return (T)Stream.of(items).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("firstNonNull method should have at least one non null parameter"));
    }

    private static String getHistoryId(String name, List<Parameter> parameters) {
        MessageDigest digest = Allure1Plugin.getMessageDigest();
        digest.update(name.getBytes(StandardCharsets.UTF_8));
        parameters.stream().sorted(PARAMETER_COMPARATOR).forEachOrdered(parameter -> {
            digest.update(Objects.toString(parameter.getName()).getBytes(StandardCharsets.UTF_8));
            digest.update(Objects.toString(parameter.getValue()).getBytes(StandardCharsets.UTF_8));
        });
        byte[] bytes = digest.digest();
        return new BigInteger(1, bytes).toString(16);
    }

    private static MessageDigest getMessageDigest() {
        try {
            return MessageDigest.getInstance(MD_5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not find md5 hashing algorithm", e);
        }
    }

    private Map<String, String> processEnvironment(Path directory) {
        Map<String, String> environment = this.processEnvironmentProperties(directory);
        environment.putAll(this.processEnvironmentXml(directory));
        return environment;
    }

    private Map<String, String> processEnvironmentProperties(Path directory) {
        Path envPropsFile = directory.resolve("environment.properties");
        final LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        if (Files.exists(envPropsFile, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(envPropsFile, new OpenOption[0]);){
                new Properties(){

                    @Override
                    public Object put(Object key, Object value) {
                        return items.put((String)key, (String)value);
                    }
                }.load(is);
            }
            catch (IOException e) {
                LOGGER.error("Could not read environments.properties file " + envPropsFile, (Throwable)e);
            }
        }
        return items;
    }

    private Map<String, String> processEnvironmentXml(Path directory) {
        Path envXmlFile = directory.resolve("environment.xml");
        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
        if (Files.exists(envXmlFile, new LinkOption[0])) {
            try (InputStream fis = Files.newInputStream(envXmlFile, new OpenOption[0]);){
                ((Environment)this.xmlMapper.readValue(fis, Environment.class)).getParameter().forEach(p -> items.put(p.getKey(), p.getValue()));
            }
            catch (Exception e) {
                LOGGER.error("Could not read environment.xml file " + envXmlFile.toAbsolutePath(), (Throwable)e);
            }
        }
        return items;
    }
}

