/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.util;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyVisitor.class);
    private final Path sourceDirectory;
    private final Path outputDirectory;

    public CopyVisitor(Path sourceDirectory, Path outputDirectory) {
        this.sourceDirectory = sourceDirectory;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Could not create directory", (Throwable)e);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (Files.notExists(file, new LinkOption[0])) {
            return FileVisitResult.CONTINUE;
        }
        Path dest = this.outputDirectory.resolve(this.sourceDirectory.relativize(file));
        try {
            Files.copy(file, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.error("Could not copy file", (Throwable)e);
        }
        return FileVisitResult.CONTINUE;
    }
}

