/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Constants {
    public static final String DEFAULT_REPORT_NAME = "Allure Report";
    public static final String WIDGETS_DIR = "widgets";
    public static final String DATA_DIR = "data";
    public static final String PLUGINS_DIR = "plugins";
    public static final String EXPORT_DIR = "export";
    public static final String HISTORY_DIR = "history";
    public static final String NO_ANALYTICS = "ALLURE_NO_ANALYTICS";

    private Constants() {
        throw new IllegalStateException("Do not instance");
    }

    public static String pluginPath(String ... pathItems) {
        return Constants.path(PLUGINS_DIR, pathItems);
    }

    public static String exportPath(String ... pathItems) {
        return Constants.path(EXPORT_DIR, pathItems);
    }

    public static String dataPath(String ... pathItems) {
        return Constants.path(DATA_DIR, pathItems);
    }

    public static String widgetsPath(String ... pathItems) {
        return Constants.path(WIDGETS_DIR, pathItems);
    }

    public static String historyPath(String ... pathItems) {
        return Constants.path(HISTORY_DIR, pathItems);
    }

    public static String path(String first, String ... others) {
        return Stream.concat(Stream.of(first), Stream.of(others)).collect(Collectors.joining("/"));
    }
}

