/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.plugin;

import io.qameta.allure.Extension;
import io.qameta.allure.PluginConfiguration;
import io.qameta.allure.core.Plugin;
import io.qameta.allure.util.CopyVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultPlugin
implements Plugin {
    private final PluginConfiguration configuration;
    private final List<Extension> extensions;
    private final Path pluginDirectory;

    public DefaultPlugin(PluginConfiguration configuration, List<Extension> extensions, Path pluginDirectory) {
        this.configuration = configuration;
        this.extensions = extensions;
        this.pluginDirectory = pluginDirectory;
    }

    public PluginConfiguration getConfig() {
        return this.configuration;
    }

    public void unpackReportStatic(Path outputDirectory) throws IOException {
        Path pluginStatic = this.getPluginStatic();
        if (Files.exists(pluginStatic, new LinkOption[0])) {
            Files.walkFileTree(pluginStatic, (FileVisitor<? super Path>)new CopyVisitor(pluginStatic, outputDirectory));
        }
    }

    public Map<String, Path> getPluginFiles() {
        final Path pluginStatic = this.getPluginStatic();
        final HashMap result = new HashMap();
        if (Files.exists(pluginStatic, new LinkOption[0])) {
            try {
                SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String fileId = pluginStatic.relativize(file).toString();
                        result.put(fileId, file);
                        return FileVisitResult.CONTINUE;
                    }
                };
                Files.walkFileTree(pluginStatic, (FileVisitor<? super Path>)visitor);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    private Path getPluginStatic() {
        return this.pluginDirectory.resolve("static");
    }
}

