/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure;

import com.opencsv.bean.HeaderColumnNameMappingStrategy;
import com.opencsv.bean.HeaderColumnNameMappingStrategyBuilder;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import io.qameta.allure.Aggregator2;
import io.qameta.allure.Constants;
import io.qameta.allure.ReportStorage;
import io.qameta.allure.core.Configuration;
import io.qameta.allure.core.LaunchResults;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public abstract class CommonCsvExportAggregator2<T>
implements Aggregator2 {
    private final String fileName;
    private final Class<T> type;

    public CommonCsvExportAggregator2(String fileName, Class<T> type) {
        this.fileName = fileName;
        this.type = type;
    }

    @Override
    public void aggregate(Configuration configuration, List<LaunchResults> launchesResults, ReportStorage storage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            StatefulBeanToCsvBuilder builder = new StatefulBeanToCsvBuilder((Writer)writer);
            HeaderColumnNameMappingStrategy mappingStrategy = new HeaderColumnNameMappingStrategyBuilder().build();
            mappingStrategy.setType(this.type);
            StatefulBeanToCsv beanWriter = builder.withMappingStrategy((MappingStrategy)mappingStrategy).build();
            try {
                beanWriter.write(this.getData(launchesResults));
            }
            catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        storage.addDataBinary(Constants.dataPath(this.fileName), bos.toByteArray());
    }

    protected abstract List<T> getData(List<LaunchResults> var1);
}

