/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.packages;

import io.qameta.allure.CommonJsonAggregator2;
import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.LabelName;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.tree.DefaultTreeLayer;
import io.qameta.allure.tree.TestResultGroupFactory;
import io.qameta.allure.tree.TestResultTree;
import io.qameta.allure.tree.TestResultTreeGroup;
import io.qameta.allure.tree.TestResultTreeLeaf;
import io.qameta.allure.tree.Tree;
import io.qameta.allure.tree.TreeGroupFactory;
import io.qameta.allure.tree.TreeLayer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class PackagesPlugin
extends CommonJsonAggregator2 {
    public PackagesPlugin() {
        super("data", "packages.json");
    }

    public Tree<TestResult> getData(List<LaunchResults> launchResults) {
        TestResultTree packages = new TestResultTree("packages", this::groupByPackages, (TreeGroupFactory)new TestResultGroupFactory(), this::createLeaf);
        launchResults.stream().map(LaunchResults::getResults).flatMap(Collection::stream).sorted(TestResult.comparingByTimeAsc()).forEach(arg_0 -> ((Tree)packages).add(arg_0));
        return this.collapseGroupsWithOnlyOneChild((Tree<TestResult>)packages);
    }

    protected List<TreeLayer> groupByPackages(TestResult testResult) {
        return testResult.findOneLabel(LabelName.PACKAGE).map(packageName -> Arrays.asList(packageName.split("\\."))).orElseGet(Collections::emptyList).stream().map(xva$0 -> new DefaultTreeLayer(new String[]{xva$0})).collect(Collectors.toList());
    }

    protected Tree<TestResult> collapseGroupsWithOnlyOneChild(Tree<TestResult> packages) {
        packages.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).forEach(this::collapseGroupsWithOnlyOneChild);
        return packages;
    }

    protected void collapseGroupsWithOnlyOneChild(TestResultTreeGroup groupNode) {
        groupNode.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).forEach(this::collapseGroupsWithOnlyOneChild);
        long count = groupNode.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).count();
        if (groupNode.getChildren().size() == 1 && count == 1L) {
            groupNode.getChildren().stream().filter(TestResultTreeGroup.class::isInstance).map(TestResultTreeGroup.class::cast).forEach(next -> {
                String name = this.getName(groupNode, (TestResultTreeGroup)next);
                groupNode.setName(name);
                groupNode.setUid(name);
                groupNode.setChildren(next.getChildren());
            });
        }
    }

    protected String getName(TestResultTreeGroup parent, TestResultTreeGroup child) {
        return String.format("%s.%s", parent.getName(), child.getName());
    }

    private TestResultTreeLeaf createLeaf(TestResultTreeGroup parent, TestResult testResult) {
        String name = testResult.findOneLabel(LabelName.TEST_METHOD).filter(method -> !method.isEmpty()).orElseGet(() -> ((TestResult)testResult).getName());
        return new TestResultTreeLeaf(parent.getUid(), name, testResult);
    }
}

