/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.output;

import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TransformingOutput<K, V, S, T>
extends CommandOutput<K, V, T> {
    private final CommandOutput<K, V, S> delegate;
    private final Function<TransformingAccessor, T> mappingFunction;
    private final TransformingAccessor accessor;

    private TransformingOutput(CommandOutput<K, V, S> delegate, Function<TransformingAccessor, T> mappingFunction) {
        super(delegate.codec, null);
        this.delegate = delegate;
        this.mappingFunction = mappingFunction;
        this.accessor = new TransformingAccessor(delegate);
    }

    public static <K, V, S, T> CommandOutput<K, V, T> transform(CommandOutput<K, V, S> delegate, Function<TransformingAccessor, T> mappingFunction) {
        return new TransformingOutput<K, V, S, T>(delegate, mappingFunction);
    }

    @Override
    public void set(ByteBuffer bytes) {
        this.delegate.set(bytes);
    }

    @Override
    public void setSingle(ByteBuffer bytes) {
        this.delegate.setSingle(bytes);
    }

    @Override
    public void setBigNumber(ByteBuffer bytes) {
        this.delegate.setBigNumber(bytes);
    }

    @Override
    public void set(long integer) {
        this.delegate.set(integer);
    }

    @Override
    public void set(double number) {
        this.delegate.set(number);
    }

    @Override
    public void set(boolean value) {
        this.delegate.set(value);
    }

    @Override
    public void setError(ByteBuffer error) {
        this.delegate.setError(error);
    }

    @Override
    public void setError(String error) {
        this.delegate.setError(error);
    }

    @Override
    public boolean hasError() {
        return this.delegate.hasError();
    }

    @Override
    public String getError() {
        return this.delegate.getError();
    }

    @Override
    public T get() {
        return this.mappingFunction.apply(this.accessor);
    }

    @Override
    public void complete(int depth) {
        this.delegate.complete(depth);
    }

    @Override
    public void multi(int count) {
        this.delegate.multi(count);
    }

    @Override
    public void multiArray(int count) {
        this.delegate.multiArray(count);
    }

    @Override
    public void multiPush(int count) {
        this.delegate.multiPush(count);
    }

    @Override
    public void multiMap(int count) {
        this.delegate.multiMap(count);
    }

    @Override
    public void multiSet(int count) {
        this.delegate.multiSet(count);
    }

    public static class TransformingAccessor {
        private final CommandOutput<?, ?, ?> delegate;

        private TransformingAccessor(CommandOutput<?, ?, ?> delegate) {
            this.delegate = delegate;
        }

        public <T> T get() {
            return (T)this.delegate.get();
        }

        public <K, V> Map<K, V> map() {
            return (Map)this.delegate.get();
        }

        public <T> List<T> list() {
            return (List)this.delegate.get();
        }

        public <T> T item(int index) {
            return this.list().get(index);
        }
    }
}

