/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.system;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.function.TriFunction;
import pl.akmf.ksef.sdk.api.services.DefaultCryptographyService;
import pl.akmf.ksef.sdk.client.model.invoice.InvoicePackagePart;
import pl.akmf.ksef.sdk.client.model.session.EncryptionData;
import pl.akmf.ksef.sdk.client.model.session.FileMetadata;
import pl.akmf.ksef.sdk.client.model.session.batch.BatchPartStreamSendingInfo;
import pl.akmf.ksef.sdk.client.model.util.ZipInputStreamWithSize;

public class FilesUtil {
    private FilesUtil() {
    }

    public static Map<String, byte[]> generateInvoicesInMemory(int invoicesCount, String contextNip, String invoiceTemplate) {
        HashMap<String, byte[]> invoiceMap = new HashMap<String, byte[]>();
        for (int i = 0; i < invoicesCount; ++i) {
            String invoice = invoiceTemplate.replace("#nip#", contextNip).replace("#invoicing_date#", LocalDate.of(2025, 6, 15).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).replace("#invoice_number#", UUID.randomUUID().toString());
            invoiceMap.put("faktura_" + (i + 1) + ".xml", invoice.getBytes(StandardCharsets.UTF_8));
        }
        return invoiceMap;
    }

    public static List<BatchPartStreamSendingInfo> splitAndEncryptZipStream(InputStream zipInputStream, int invoicesPartCount, int zipLength, byte[] cipherKey, byte[] cipherIv, DefaultCryptographyService cryptographyService) throws IOException {
        int bytesRead;
        ArrayList<BatchPartStreamSendingInfo> encryptedStreamParts = new ArrayList<BatchPartStreamSendingInfo>();
        int partSize = (int)Math.ceil((double)zipLength / (double)invoicesPartCount);
        byte[] buffer = new byte[partSize];
        for (int partIndex = 0; (bytesRead = zipInputStream.read(buffer)) != -1 && partIndex < invoicesPartCount; ++partIndex) {
            ByteArrayInputStream partInputStream = new ByteArrayInputStream(buffer, 0, bytesRead);
            ByteArrayOutputStream encryptedBaos = new ByteArrayOutputStream();
            cryptographyService.encryptStreamWithAES256(partInputStream, encryptedBaos, cipherKey, cipherIv);
            byte[] encryptedBytes = encryptedBaos.toByteArray();
            ByteArrayInputStream encryptedInputStream = new ByteArrayInputStream(encryptedBytes);
            FileMetadata metadata = cryptographyService.getMetaData(encryptedInputStream);
            encryptedInputStream.reset();
            encryptedStreamParts.add(new BatchPartStreamSendingInfo(encryptedInputStream, metadata, partIndex + 1));
        }
        return encryptedStreamParts;
    }

    public static List<byte[]> splitZip(int partsCount, byte[] zipBytes) {
        int start;
        int size;
        int partSize = (int)Math.ceil((double)zipBytes.length / (double)partsCount);
        ArrayList<byte[]> zipParts = new ArrayList<byte[]>();
        for (int i = 0; i < partsCount && (size = Math.min(partSize, zipBytes.length - (start = i * partSize))) > 0; ++i) {
            byte[] part = Arrays.copyOfRange(zipBytes, start, start + size);
            zipParts.add(part);
        }
        return zipParts;
    }

    public static byte[] createZip(Map<String, byte[]> files) throws IOException {
        byte[] zipBytes;
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("Map of files cannot be null or empty.");
        }
        try (ByteArrayOutputStream zipStream = new ByteArrayOutputStream();
             ZipOutputStream archive = new ZipOutputStream(zipStream);){
            for (Map.Entry<String, byte[]> entry : files.entrySet()) {
                String fileName = entry.getKey();
                byte[] fileContent = entry.getValue();
                if (fileName == null || fileContent == null) continue;
                archive.putNextEntry(new ZipEntry(fileName));
                archive.write(fileContent);
                archive.closeEntry();
            }
            archive.finish();
            zipBytes = zipStream.toByteArray();
        }
        return zipBytes;
    }

    public static ZipInputStreamWithSize createZipInputStream(Map<String, byte[]> files) throws IOException {
        if (files == null || files.isEmpty()) {
            throw new IllegalArgumentException("Map of files cannot be null or empty.");
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ZipInputStreamWithSize zipInputStreamWithSize;
            try (ZipOutputStream zipOut = new ZipOutputStream(baos);){
                for (Map.Entry<String, byte[]> entry : files.entrySet()) {
                    String fileName = entry.getKey();
                    byte[] content = entry.getValue();
                    if (fileName == null || content == null) continue;
                    ZipEntry zipEntry = new ZipEntry(fileName);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.write(content);
                    zipOut.closeEntry();
                }
                zipOut.finish();
                zipOut.flush();
                byte[] zipBytes = baos.toByteArray();
                int zipLength = zipBytes.length;
                zipInputStreamWithSize = new ZipInputStreamWithSize(new ByteArrayInputStream(zipBytes), zipLength);
            }
            return zipInputStreamWithSize;
        }
    }

    public static Map<String, String> unzip(byte[] zipBytes) throws IOException {
        HashMap<String, String> files = new HashMap<String, String>();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(zipBytes);
             ZipInputStream zis = new ZipInputStream((InputStream)bais, StandardCharsets.UTF_8);){
            ZipEntry entry;
            byte[] buffer = new byte[8192];
            while ((entry = zis.getNextEntry()) != null) {
                int bytesRead;
                if (entry.getName().isBlank()) continue;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((bytesRead = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                String content = baos.toString(StandardCharsets.UTF_8);
                files.put(entry.getName(), content);
                zis.closeEntry();
            }
        }
        return files;
    }

    public static byte[] mergeZipParts(EncryptionData encryptionData, List<InvoicePackagePart> parts, Function<InvoicePackagePart, byte[]> downloadPackagePartFunction, TriFunction<byte[], byte[], byte[], byte[]> decryptBytesWithAes256TriFunction) {
        Object object;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            for (InvoicePackagePart part : parts) {
                byte[] encryptedPackagePart = downloadPackagePartFunction.apply(part);
                byte[] decryptBytesPackagePart = (byte[])decryptBytesWithAes256TriFunction.apply((Object)encryptedPackagePart, (Object)encryptionData.cipherKey(), (Object)encryptionData.cipherIv());
                if (decryptBytesPackagePart == null || decryptBytesPackagePart.length <= 0) continue;
                outputStream.write(decryptBytesPackagePart);
            }
            object = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        outputStream.close();
        return object;
    }
}

