/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.sign;

import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs12SignatureToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import pl.akmf.ksef.sdk.sign.CertUtil;
import pl.akmf.ksef.sdk.sign.SignContextProvider;
import pl.akmf.ksef.sdk.sign.SignSignatureException;

public class LocalSigningContext
implements SignContextProvider {
    public static final String PKCS_12 = "PKCS12";
    public static final String CUSTOM_KEYSTORE_ALIAS = "alias";

    @Override
    public SignatureValue createSignatureValue(ToBeSigned toBeSigned, X509Certificate signatureCertificate, PrivateKey privateKey) {
        SignatureValue signatureValue;
        block12: {
            SignatureAlgorithm signatureAlgorithm;
            KeyStore keystore = KeyStore.getInstance(PKCS_12);
            keystore.load(null, null);
            Certificate[] chain = new Certificate[]{signatureCertificate};
            keystore.setKeyEntry(CUSTOM_KEYSTORE_ALIAS, privateKey, null, chain);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            keystore.store(baos, null);
            byte[] keystoreBytes = baos.toByteArray();
            DSSPrivateKeyEntry dssPrivateKeyEntry = this.getPrivateKeyEntry(keystore);
            if (CertUtil.isMatchingRsaPair(signatureCertificate, privateKey)) {
                signatureAlgorithm = SignatureAlgorithm.RSA_SHA256;
            } else if (CertUtil.isMatchingEcdsaPair(signatureCertificate, privateKey)) {
                ECPublicKey ecPublicKey = (ECPublicKey)signatureCertificate.getPublicKey();
                int keySize = ecPublicKey.getParams().getCurve().getField().getFieldSize();
                signatureAlgorithm = keySize <= 256 ? SignatureAlgorithm.ECDSA_SHA256 : (keySize <= 384 ? SignatureAlgorithm.ECDSA_SHA384 : SignatureAlgorithm.ECDSA_SHA512);
            } else {
                throw new IllegalArgumentException("Encoding data are incorrect: \nCertificate signatureAlg: " + signatureCertificate.getSigAlgName() + "\nPublicKey signatureAlg: " + signatureCertificate.getPublicKey().getAlgorithm() + "\nPrivateKEy signatureAlg: " + privateKey.getAlgorithm());
            }
            Pkcs12SignatureToken token = this.createPkcs12Token(keystoreBytes);
            try {
                signatureValue = token.sign(toBeSigned, signatureAlgorithm, dssPrivateKeyEntry);
                if (token == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (token != null) {
                        try {
                            token.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                    throw new SignSignatureException("Failed to create signature value", e);
                }
            }
            token.close();
        }
        return signatureValue;
    }

    private DSSPrivateKeyEntry getPrivateKeyEntry(KeyStore keyStore) throws UnrecoverableEntryException, NoSuchAlgorithmException, KeyStoreException {
        KeyStore.PasswordProtection keyPasswordProtection = new KeyStore.PasswordProtection(null);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(CUSTOM_KEYSTORE_ALIAS, keyPasswordProtection);
        return new KSPrivateKeyEntry(CUSTOM_KEYSTORE_ALIAS, privateKeyEntry);
    }

    private Pkcs12SignatureToken createPkcs12Token(byte[] keystoreBytes) {
        return new Pkcs12SignatureToken(keystoreBytes, new KeyStore.PasswordProtection(null));
    }
}

