/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.qr;

import io.alapierre.ksef.Environment;
import io.alapierre.ksef.qr.CryptoUtils;
import java.security.PrivateKey;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.akmf.ksef.sdk.client.model.qrcode.ContextIdentifierType;

public final class VerificationLinkGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VerificationLinkGenerator.class);
    private static final DateTimeFormatter KSEF_DATE = DateTimeFormatter.ofPattern("dd-MM-yyyy");

    private VerificationLinkGenerator() {
    }

    public static String generateVerificationLink(Environment environment, String nip, LocalDate issueDate, byte[] invoiceXml) {
        String base = VerificationLinkGenerator.trimTrailingSlash(environment.getQrBaseUrl());
        String normalizedNip = VerificationLinkGenerator.normalizeAndValidateNip(nip);
        String date = issueDate.format(KSEF_DATE);
        String hash = CryptoUtils.computeInvoiceHashBase64Url(invoiceXml);
        return String.format("%s/invoice/%s/%s/%s", base, normalizedNip, date, hash);
    }

    public static String generateCertificateVerificationLink(Environment environment, ContextIdentifierType ctxType, String ctxValue, String sellerNip, String certSerial, PrivateKey privateKey, byte[] invoiceHash) {
        String invoiceHashUrlEncoded = Base64.getUrlEncoder().withoutPadding().encodeToString(invoiceHash);
        String baseUrl = VerificationLinkGenerator.trimTrailingSlash(environment.getQrBaseUrl());
        String normalizedNip = VerificationLinkGenerator.normalizeAndValidateNip(sellerNip);
        String pathToSign = String.format("%s/certificate/%s/%s/%s/%s/%s", baseUrl, ctxType.getValue(), ctxValue, normalizedNip, certSerial, invoiceHashUrlEncoded).replace("https://", "");
        String signedHash = CryptoUtils.computeUrlEncodedSignedHash(pathToSign, privateKey);
        return String.format("%s/certificate/%s/%s/%s/%s/%s/%s", baseUrl, ctxType.getValue(), ctxValue, normalizedNip, certSerial, invoiceHashUrlEncoded, signedHash);
    }

    private static String trimTrailingSlash(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Environment URL is null");
        }
        return url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    private static String normalizeAndValidateNip(String nip) {
        String digits;
        String string = digits = nip == null ? "" : nip.replaceAll("\\D", "");
        if (digits.length() != 10) {
            throw new IllegalArgumentException("NIP must contain exactly 10 digits");
        }
        return digits;
    }
}

