/*
 * Decompiled with CFR 0.152.
 */
package io.alapierre.ksef.qr;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import io.alapierre.ksef.qr.exceptions.BarcodeGenerationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QrCodeGenerator.class);

    private QrCodeGenerator() {
    }

    public static byte[] generateBarcode(@NonNull String barcodeText, int width, int height) {
        if (barcodeText == null) {
            throw new NullPointerException("barcodeText is marked non-null but is null");
        }
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            QrCodeGenerator.writeBarcode(barcodeText, width, height, buf);
            return buf.toByteArray();
        }
        catch (IOException ex) {
            log.debug(ex.getLocalizedMessage(), (Throwable)ex);
            throw new BarcodeGenerationException(ex);
        }
    }

    public static void writeBarcode(@NonNull String barcodeText, int width, int height, OutputStream out) throws IOException {
        if (barcodeText == null) {
            throw new NullPointerException("barcodeText is marked non-null but is null");
        }
        if (width <= 0 || height <= 0) {
            throw new BarcodeGenerationException("width and height must be positive", null);
        }
        try {
            QRCodeWriter barcodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.QR_CODE, width, height);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)out);
        }
        catch (WriterException ex) {
            log.debug(ex.getLocalizedMessage(), (Throwable)ex);
            throw new BarcodeGenerationException("Failed to generate barcode: " + ex.getLocalizedMessage());
        }
    }
}

